/*

  silcmemory.c 

  Author: Pekka Riikonen <priikone@silcnet.org>

  Copyright (C) 1999 - 2002 Pekka Riikonen

  The contents of this file are subject to one of the Licenses specified 
  in the COPYING file;  You may not use this file except in compliance 
  with the License.

  The software distributed under the License is distributed on an "AS IS"
  basis, in the hope that it will be useful, but WITHOUT WARRANTY OF ANY
  KIND, either expressed or implied.  See the COPYING file for more
  information.

*/
/* $Id: silcmemory.c,v 1.6.2.3 2002/11/30 12:31:30 priikone Exp $ */

#include "silcincludes.h"

#ifndef SILC_STACKTRACE

#define SILC_MAX_ALLOC (1024 * 1024L * 1024L)

void *silc_malloc(size_t size)
{
  void *addr;
  assert(size >= 0 && size <= SILC_MAX_ALLOC);
  addr = malloc(size);
  assert(addr != NULL);
  return addr;
}

void *silc_calloc(size_t items, size_t size)
{
  void *addr;
  assert(size * items >= 0 && size * items <= SILC_MAX_ALLOC);
  addr = calloc(items, size);
  assert(addr != NULL);
  return addr;
}

void *silc_realloc(void *ptr, size_t size)
{
  void *addr;
  assert(size >= 0 && size <= SILC_MAX_ALLOC);
  addr = realloc(ptr, size);
  assert(addr != NULL);
  return addr;
}

void silc_free(void *ptr)
{
  free(ptr);
}

void *silc_memdup(const void *ptr, size_t size)
{
  unsigned char *addr;
  addr = silc_malloc(size + 1);
  assert(addr != NULL);
  memcpy((void *)addr, ptr, size);
  addr[size] = '\0';
  return (void *)addr;
}

#endif /* !SILC_STACKTRACE */
