/*   -*- c -*-
 *
 *  ----------------------------------------------------------------------
 *  Deque for struct type with only one link pointer (x->next).
 *  Functions that can be implemented also as macros.
 *  ----------------------------------------------------------------------
 *  Created	 : Sat Nov 18 11:12:23 1995 tri
 *  Last modified: Thu Apr 23 17:00:47 1998 tri
 *  ----------------------------------------------------------------------
 *  Copyright  1995-1998
 *  Timo J. Rinne <tri@iki.fi>
 *  All rights reserved.  See file COPYRIGHT for details.
 *
 *  Address: Cirion oy, PO-BOX 250, 00121 Helsinki, Finland
 *  ----------------------------------------------------------------------
 *  Any express or implied warranties are disclaimed.  In no event
 *  shall the author be liable for any damages caused (directly or
 *  otherwise) by the use of this software.
 *
 *  Please, send your patches to <tri@iki.fi>.
 *  ----------------------------------------------------------------------
 *
 * $Id: trq_deque.c,v 1.1.1.1 2000/10/31 19:59:30 priikone Exp $
 *
 * $Log: trq_deque.c,v $
 * Revision 1.1.1.1  2000/10/31 19:59:30  priikone
 * 	Imported TRQ and SilList and SilcDList API's.
 *
 * Revision 1.11  1998/06/22 07:15:32  tri
 * trq_list_member_p -> trq_list_member
 * trq_deque_member_p -> trq_deque_member
 * trq_list_pointer_valid_p -> trq_list_pointer_valid
 * trq_list_compatible_p -> trq_list_compatible
 * trq_deque_compatible_p -> trq_deque_compatible
 *
 * Revision 1.10  1998/06/21 15:26:25  tri
 * Changed symbol names of function versions of the trq_calls.
 *
 * Revision 1.9  1998/06/18 07:22:12  tri
 * Heavy rethinking of the concepts in the deque
 * and the list.  For now on both deque and list
 * start from `tail' and end to `head'.  Sorting
 * functions make order ascending from tail to head.
 * Moving list pointer forward, move it towards head
 * and moving it backwards move it towards tail.
 *
 * Terms head and tail are utilized also in lists
 * replacing old `first' and `last'.
 *
 * Now they should make sense.
 *
 * Revision 1.8  1998/04/23 14:07:56  tri
 * Made single TRQ_USE_FUNCTIONS instead of
 * separate one for lists and deques.
 *
 * Revision 1.7  1998/04/20 15:05:06  tri
 * SNAFU in search and replace.
 *
 * Revision 1.6  1998/04/20 14:55:17  tri
 * Final solution for deque basic operation names.
 * Now they are trq_deque_insert_tail, trq_deque_insert_head,
 * trq_deque_get_tail and trq_deque_get_head.  After intensive
 * customer survey, this seems to be the most intuitive way.
 *
 * Revision 1.5  1998/04/19 13:59:10  tri
 * Minor fix.
 *
 * Revision 1.4  1998/04/19 13:57:57  tri
 * Added trq_deque_empty_p.
 *
 * Revision 1.3  1998/04/18 10:29:47  tri
 * Renamed API functions to more intuitive form:
 * trq_deque_put_last to trq_deque_put,
 * trq_deque_put to trq_deque_push,
 * trq_deque_get_head to trq_deque_pop,
 * trq_deque_mapcar_bw to trq_deque_mapcar_reverse,
 * trq_list_mapcar_bw to trq_list_mapcar_reverse,
 * trq_deque_join_bw to trq_deque_join_tail and
 * trq_deque_join to trq_deque_join_head.
 *
 * Revision 1.2  1998/04/17 08:51:57  tri
 * Types `deque' and `list' and constants `DEQUE_NO_ITEM'
 * and `LIST_NO_ITEM' prefixed with `trq_' and `TRQ_'
 * accordingly.
 *
 * Revision 1.1	 1998/04/16 14:39:41  tri
 * Initial revision
 *
 *
 */

#ifdef TRQ_USE_FUNCTIONS
#  undef TRQ_USE_FUNCTIONS
#endif
#define TRQ_USE_FUNCTIONS	0

#include <trq_deque.h>

void trq_deque_clear___func(trq_deque *Q)
{
    (void)trq_deque_clear(Q);
}

int trq_deque_empty_p___func(trq_deque *Q)
{
    return trq_deque_empty_p(Q);
}

int trq_deque_insert_tail___func(trq_deque *Q, void *b)
{
    return trq_deque_insert_tail(Q, b);
}

void *trq_deque_get_head___func(trq_deque *Q)
{
    return trq_deque_get_head(Q);
}

int trq_deque_insert_head___func(trq_deque *Q, void *b)
{
    return trq_deque_insert_head(Q, b);
}

void *trq_deque_get_tail___func(trq_deque *Q)
{
    return trq_deque_get_tail(Q);
}

int trq_deque_length___func(trq_deque *Q)
{
    return trq_deque_length(Q);
}

int trq_deque_reverse___func(trq_deque *Q)
{
    return trq_deque_reverse(Q);
}

int trq_deque_compatible___func(trq_deque *Q1, trq_deque *Q2)
{
    return trq_deque_compatible(Q1, Q2);
}

void trq_deque_init_with_offset___func(trq_deque *Q, trq_p_i_t o)
{
    (void)trq_deque_init_with_offset(Q, o);
}

/* eof (trq_deque.c) */
