## NOTE: tor.spec is autogenerated from tor.spec.in . Edit the latter,
## not the former.

## Things that need to be edited frequently
#
# This should be incremented whenever the spec file changes, but
# can drop back to zero at a new Tor version

%define specver 0

## Things users may want to change
#
# User (and group) name under which the Tor daemon runs

%define runuser _tor

## Version song and dance
#
# This should be the Tor version number, as it appears on the tarball,
# including any "pre<x>" or "rc<y>" suffix. This gets massaged to
# create the RPM version number, in a way that depends on the Tor
# numbering scheme.
%define native_version       0.1.0.5-rc

%define version %(echo %{native_version} | sed -e 's/-/./g')

## Release and OS identification song and dance
#
# This identifies the lineage of the spec file. This file is the
# standard one that comes with Tor; various distributions may
# have their own ideas about the right ways to do things.
%define pkgspec tor

# This spec is intended to build and install on multiple distributions.
# Detect the distribution we're building on.

%define is_rh   %(test -e /etc/redhat-release && echo 1 || echo 0)
%define is_fc   %(test -e /etc/fedora-release && echo 1 || echo 0)
%define is_mdk  %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)

%if %{is_fc}
%define ostag %(sed -e 's/^.*release /fc/' -e 's/ .*$//' -e 's/\\./_/g' < /etc/fedora-release)
%else
%if %{is_rh}
%define ostag %(sed -e 's/^.*release /rh/' -e 's/ .*$//' -e 's/\\./_/g' < /etc/redhat-release)
%endif
%endif

# These are probably wrong... just placeholders should we actually
# end up supporting these distributions

%if %{is_mdk}
%define ostag mdk
%endif

%if %{is_suse}
%define ostag suse
%endif


# Using the build date ensures that every build really does get
# a different release number.  We use this trick for CVS versions.
# For release versions, we don't want or need it.
%define is_cvs_version %(echo %{native_version} | grep 'cvs' > /dev/null && echo 1 || echo 0)

%if %{is_cvs_version}
%define blddate %(date -u +"%Y%m%d%H%M")
%define release %{pkgspec}.%{specver}.%{ostag}.%{blddate}
%else
%define release %{pkgspec}.%{specver}.%{ostag}
%endif

## General-purpose macros
#
# Some systems don't have some macros. If a macro doesn't seem
# to exist on your system, add it here...

%if %{!?__make:1}%{?__make:0}
%define __make make
%endif

%if %{!?make:1}%{?make:0}
%define make %{__make}
%endif

%if %{!?_localstatedir:1}%{?_localstatedir:0}
%define _localstatedir /usr/local/var
%endif

## Package information
#
Name: tor
Version: %{version}
Release: %{release}

Summary: Anonymizing overlay network for TCP (The onion router)
URL: http://tor.eff.org/
Group: System Environment/Daemons

License: BSD-like
Vendor: R. Dingledine <arma@seul.org>
Packager: Nick Mathewson <nickm@seul.org>

Requires: openssl >= 0.9.6
BuildRequires: openssl-devel >= 0.9.6, rpm-build >= 4.0
Requires(pre): shadow-utils, /usr/bin/id, /bin/date, /bin/sh
Requires(pre): %{_sbindir}/useradd, %{_sbindir}/groupadd

Source0: http://tor.eff.org/dist/%{name}-%{native_version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

%description
Tor is a connection-based low-latency anonymous communication system.

This package provides the "tor" program, which serves as both a client and
a relay node. Scripts will automatically create a "%{runuser}" user and
group, and set tor up to run as a daemon when the system is rebooted.

Applications connect to the local Tor proxy using the SOCKS
protocol. The local proxy chooses a path through a set of relays, in
which each relay knows its predecessor and successor, but no
others. Traffic flowing down the circuit is unwrapped by a symmetric
key at each relay, which reveals the downstream relay.

Warnings: Tor does no protocol cleaning.  That means there is a danger
that application protocols and associated programs can be induced to
reveal information about the initiator. Tor depends on Privoxy and
similar protocol cleaners to solve this problem. This is alpha code,
and is even more likely than released code to have anonymity-spoiling
bugs. The present network is very small -- this further reduces the
strength of the anonymity provided. Tor is not presently suitable
for high-stakes anonymity.

%prep
%setup -q -n %{name}-%{native_version}

# Patch the startup script to use the right user and group IDs. Force
# the use of /bin/sh as the shell for the "tor" account.
ed -s contrib/tor.sh.in << '/EOF/' > /dev/null
,s/^TORUSER=$/TORUSER=%{runuser}/
,s/^TORGROUP=$/TORGROUP=%{runuser}/
,s:/bin/su:/bin/su -s /bin/sh:
#
# Save and exit ed
w
q
/EOF/

%build
%configure
%make

%install
%makeinstall

# Install init script.
%__mkdir_p ${RPM_BUILD_ROOT}%{_initrddir}
%__install -p -m 755 contrib/tor.sh ${RPM_BUILD_ROOT}%{_initrddir}/%{name}

# Set up config file; "sample" file implements a basic user node.
%__install -p -m 644 ${RPM_BUILD_ROOT}%{_sysconfdir}/%{name}/torrc.sample ${RPM_BUILD_ROOT}%{_sysconfdir}/%{name}/torrc

# Create a logrotate file. This should really be a source file,
# but hey...
%__mkdir_p -m 755 ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d
%__cat > ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/%{name} << /EOF/
%{_localstatedir}/log/%{name}/*log {
	daily
	rotate 5
	compress
	delaycompress
	missingok
	notifempty
	sharedscripts
	postrotate
		/etc/rc.d/init.d/tor reload > /dev/null
	endscript
}
/EOF/

# Directories that don't have any preinstalled files
%__mkdir_p -m 700 ${RPM_BUILD_ROOT}%{_localstatedir}/lib/%{name}
%__mkdir_p -m 755 ${RPM_BUILD_ROOT}%{_localstatedir}/run/%{name}
%__mkdir_p -m 755 ${RPM_BUILD_ROOT}%{_localstatedir}/log/%{name}

%clean
[ "${RPM_BUILD_ROOT}" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

# These scripts are probably wrong for Mandrake or SuSe. They're certainly
# wrong for Debian, but what are you doing using RPM on Debian?
%pre
[ -f %{_initrddir}/%{name}  ] && /sbin/service %{name} stop
if [ ! -n "`/usr/bin/id -g %{runuser} 2>/dev/null`" ]; then
    # One would like to default the GID, but doing that properly would
    # require thought.
    %{_sbindir}/groupadd %{runuser} 2> /dev/null
fi
if [ ! -n "`/usr/bin/id -u %{runuser} 2>/dev/null`" ]; then
    # One would also like to default the UID, but doing that properly would
    # also require thought.
    if [ -x /sbin/nologin ]; then
        %{_sbindir}/useradd -r -g %{runuser} -d / -s /sbin/nologin %{runuser} 2> /dev/null
    else
        %{_sbindir}/useradd -r -g %{runuser} -d / -s /bin/false %{runuser} 2> /dev/null
    fi
fi
exit 0

%post
/sbin/chkconfig --add %{name}
exit 0

%preun
/sbin/chkconfig --del %{name}
%__rm -f ${_localstatedir}/lib/%{name}/cached-directory
%__rm -f ${_localstatedir}/lib/%{name}/bw_accounting
%__rm -f ${_localstatedir}/lib/%{name}/control_auth_cookie
%__rm -f ${_localstatedir}/lib/%{name}/router.desc
%__rm -f ${_localstatedir}/lib/%{name}/fingerprint
exit 0

%files
%defattr(-,root,root)
%doc AUTHORS INSTALL LICENSE README ChangeLog doc/HACKING doc/TODO doc/FAQ
%{_mandir}/man*/*
%{_bindir}/tor
%{_bindir}/torify
%{_bindir}/tor-resolve
%config %{_initrddir}/%{name}
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/logrotate.d/%{name}
%dir %attr(0755,root,%{runuser}) %{_sysconfdir}/%{name}/
%config(noreplace) %attr(0644,root,%{runuser}) %{_sysconfdir}/%{name}/*
%attr(0700,%{runuser},%{runuser}) %dir %{_localstatedir}/lib/%{name}
%attr(0750,%{runuser},%{runuser}) %dir %{_localstatedir}/run/%{name}
%attr(0750,%{runuser},%{runuser}) %dir %{_localstatedir}/log/%{name}

%changelog
* Tue Nov  5 2004 John Bashinski <jbash@velvet.com>
- Add skeletal support for multiple distributions
- Even more ridiculous level of macro-ization
- Modify version numbers so RPM can determine when it has a newer version
- Return to including distribution name in package release number
- Sharply trim description
- Change user/group name from "tor" to "tordmn"; "tor" is a common
  given name (reported by Marius Hjelle)
- Change group to "System Environment/Daemons" (suggested by Marius Hjelle)
- Create logrotate file (suggested by Marius Hjelle)
- Make Tor run as a user proxy by default (suggested by Marius Hjelle)
- Autogenerate spec file from GNU autotools data, substituting version
  and whatnot
- Be perhaps excessively paranoid with config file and directory modes
- Remove auto-start and auto-stop at installation time; there's some kind
  of weird race going on, and it's arguably a bad thing anyway.

* Mon Jun 06 2004 Nick Mathewson <nickm@freehaven.net> 0.0.7-0.std.0.1.rc2
- Make spec file more happy with fc2 packaging

* Sat Jan 17 2004 John Bashinski <jbash@velvet.com>
- Basic spec file; tested with Red Hat 9.

