/*                                                                            */
/* virtual private network daemon (vpnd)                                      */
/*                                                                            */
/* cryptographic stuff (c) 1999 Andreas Steinmetz, astmail@yahoo.com          */
/* other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz*/
/*                                                                            */
/* License:                                                                   */
/* This code is in the public domain (*) under the GNU public license.        */
/* The copyright holders will however retain their copyright.                 */
/* There is no guarantee for the fitness and usability of this code           */
/* for any purpose. The author and the copyright holders take no              */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/* (*) 'public domain' is used here in the sense of the Wassenaar treaty.     */
/*                                                                            */

	rwhite=0
	wwhite=1
	nocompress=5
	peercomp=6
	mode=11
	cipher=16
	keysize=18
	threshold=20
	encrypt=96
	local=100
	remote=104
	local_iv=108
	remote_iv=116
	white=124
	sched1=1160
	sched2=5328
 
.text

/* void checksum(WORD08 *data,WORD32 length,WORD08 *out) */

.globl checksum
		.type	checksum,@function
		.align	16
checksum:
		pushl	%ebx
		movl	12(%esp),%ecx
		movl	8(%esp),%edx
		xorl	%eax,%eax
		xorl	%ebx,%ebx
		testl	%ecx,%ecx
		jz	wsum
chkloop:	movb	(%edx),%bx
		rolw	$1,%ax
		incl	%edx
		xorw	%bx,%ax
		decl	%ecx
		jnz	chkloop
wsum:		movl	16(%esp),%edx
		popl	%ebx
		movw	%ax,(%edx)

/* void nocrypt(WORD08 *data,WORD32 *schedule) */

.globl nocrypt
		.type	nocrypt,@function

nocrypt:	ret

/* void encrypt_cfb_64_8(WORD08 *data,WORD32 total,VPN *anchor) */

.globl encrypt_cfb_64_8
		.type	encrypt_cfb_64_8,@function
		.align	16
encrypt_cfb_64_8:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		pushl	%ebp
		subl	$16,%esp

		/* copy iv to buffer */

		movl	44(%esp),%esi
		leal	local_iv(%esi),%edx
		movl	(%edx),%eax
		movl	4(%edx),%ebx
		movl	%eax,8(%esp)
		movl	%ebx,12(%esp)

		/* increase iv */

		incl	%eax
		movl	%eax,(%edx)
		jnz	noencivh
		incl	%ebx
		movl	%ebx,4(%edx)

		/* get data, total, wwhite and globals buffer address */

noencivh:	movl	36(%esp),%edi
		movl	40(%esp),%ebp
		xorl	%ebx,%ebx
		movb	wwhite(%esi),%bl
		movl	local(%esi),%ecx

		/* set up parameters for encrypt calls */

		leal	8(%esp),%eax
		movl	%eax,(%esp)
		movl	%ecx,4(%esp)

		/* for all large blocks use CFB64 */

enc64loop:	cmpl	$8,%ebp
		jnae	enc64done
		movl	encrypt(%esi),%eax
		call	*%eax
		xorl	%edx,%edx
enc64dta:	movb	(%edi),%al
		xorb	8(%esp,%edx,),%al
		movb	%al,8(%esp,%edx,)
		xorb	white(%esi,%ebx,),%al
		movb	%al,(%edi)
		incl	%edx
		incl	%edi
		incb	%bl
		cmpl	$8,%edx
		jne	enc64dta
		subl	$8,%ebp
		jmp	enc64loop

		/* for all remaining data bytes use CFB8 */

enc64done:	testl	%ebp,%ebp
		jz	enc8done
enc8loop:	movl	encrypt(%esi),%eax
		call	*%eax
		movb	(%edi),%al
		xorb	8(%esp),%al
		movl	9(%esp),%edx
		movl	13(%esp),%ecx
		movl	%edx,8(%esp)
		movl	%ecx,12(%esp)
		movb	%al,15(%esp)
		xorb	white(%esi,%ebx,),%al
		movb	%al,(%edi)
		incb	%bl
		incl	%edi
		decl	%ebp
		jnz	enc8loop

		/* save new wwhite value */

enc8done:	addl	$16,%esp
		movb	%bl,wwhite(%esi)

		popl	%ebp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

/* void decrypt_cfb_64_8(WORD08 *data,WORD32 total,VPN *anchor) */

.globl decrypt_cfb_64_8
		.type	decrypt_cfb_64_8,@function
		.align	16
decrypt_cfb_64_8:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		pushl	%ebp
		subl	$16,%esp

		/* copy iv to buffer */

		movl	44(%esp),%esi
		leal	remote_iv(%esi),%edx
		movl	(%edx),%eax
		movl	4(%edx),%ebx
		movl	%eax,8(%esp)
		movl	%ebx,12(%esp)

		/* increase iv */

		incl	%eax
		movl	%eax,(%edx)
		jnz	nodecivh
		incl	%ebx
		movl	%ebx,4(%edx)

		/* get data, total, rwhite and globals buffer address */

nodecivh:	movl	36(%esp),%edi
		movl	40(%esp),%ebp
		xorl	%ebx,%ebx
		movb	rwhite(%esi),%bl
		movl	remote(%esi),%ecx

		/* set up parameters for encrypt calls */

		leal	8(%esp),%eax
		movl	%eax,(%esp)
		movl	%ecx,4(%esp)

		/* for all large blocks use CFB64 */

dec64loop:	cmpl	$8,%ebp
		jnae	dec64done
		movl	encrypt(%esi),%eax
		call	*%eax
		xorl	%edx,%edx
dec64dta:	movb	(%edi),%al
		xorb	white(%esi,%ebx,),%al
		movb	%al,%cl
		xorb	8(%esp,%edx,),%al
		movb	%cl,8(%esp,%edx,)
		movb	%al,(%edi)
		incl	%edx
		incl	%edi
		incb	%bl
		cmpl	$8,%edx
		jne	dec64dta
		subl	$8,%ebp
		jmp	dec64loop

		/* for all remaining data bytes use CFB8 */

dec64done:	testl	%ebp,%ebp
		jz	dec8done
dec8loop:	movl	encrypt(%esi),%eax
		call	*%eax
		movb	(%edi),%al
		xorb	white(%esi,%ebx,),%al
		movb	%al,%cl
		xorb	8(%esp),%al
		movl	9(%esp),%edx
		movb	%al,(%edi)
		movl	13(%esp),%eax
		movl	%edx,8(%esp)
		movl	%eax,12(%esp)
		movb	%cl,15(%esp)
		incb	%bl
		incl	%edi
		decl	%ebp
		jnz	dec8loop

		/* save new rwhite value */

dec8done:	addl	$16,%esp
		movb	%bl,rwhite(%esi)

		popl	%ebp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

/* void genwhite(WORD08 *src,VPN *anchor) */

.globl genwhite
		.type	genwhite,@function
		.align	16
genwhite:
		pushl	%ebx
		pushl	%esi
		movl	12(%esp),%eax
		movl	16(%esp),%esi
		subl	$4180,%esp
		movl	%eax,(%esp)
		movl	$72,4(%esp)
		leal	12(%esp),%eax
		movl	%eax,8(%esp)
		call	blowfish_key_schedule
		leal	white(%esi),%esi
		xorl	%ebx,%ebx
initwhite:	movb	%bl,(%esi,%ebx,)
		incb	%bl
		jnz	initwhite
		leal	12(%esp),%eax
		movl	%eax,4(%esp)
mkwhite:	movl	%esi,(%esp)
		call	blowfish_encrypt
		call	blowfish_encrypt
		call	blowfish_encrypt
		call	blowfish_encrypt
		addl	$8,%esi
		addb	$8,%bl
		jnz	mkwhite
		xorl	%eax,%eax
clrwhite:	movl	%eax,12(%esp,%ebx,4)
		incl	%ebx
		cmpl	$1042,%ebx
		jne	clrwhite
		addl	$4180,%esp
		popl	%esi
		popl	%ebx
		ret

/* void encrypt_cbc(WORD08 *data,WORD32 len,WORD32 *schedule,WORD08 *iv) */

.globl encrypt_cbc
		.type	encrypt_cbc,@function
		.align	16
encrypt_cbc:
		pushl	%ebx
		pushl	%esi
		movl	12(%esp),%esi
		movl	16(%esp),%ebx
		movl	20(%esp),%ecx
		movl	24(%esp),%eax
		subl	$8,%esp
		movl	%ecx,4(%esp)
		shrl	$3,%ebx
		jz	enccbcdone
enccbcloop:	movl	(%esi),%ecx
		movl	4(%esi),%edx
		xorl	(%eax),%ecx
		xorl	4(%eax),%edx
		movl	%ecx,(%esi)
		movl	%edx,4(%esi)
		movl	%esi,(%esp)
		call	blowfish_encrypt
		movl	%esi,%eax
		addl	$8,%esi
		decl	%ebx
		jnz	enccbcloop
enccbcdone:	addl	$8,%esp
		popl	%esi
		popl	%ebx
		ret

/* void decrypt_cbc(WORD08 *data,WORD32 len,WORD32 *schedule,WORD08 *iv) */

.globl decrypt_cbc
		.type	decrypt_cbc,@function
		.align	16
decrypt_cbc:
		pushl	%ebx
		pushl	%esi
		movl	12(%esp),%esi
		movl	16(%esp),%ebx
		movl	20(%esp),%ecx
		movl	24(%esp),%eax
		subl	$24,%esp
		movl	%ecx,4(%esp)
		movl	(%eax),%ecx
		movl	4(%eax),%edx
		movl	%ecx,8(%esp)
		movl	%edx,12(%esp)
		shrl	$3,%ebx
		jz	deccbcdone
deccbcloop:	movl	8(%esp),%eax
		movl	12(%esp),%ecx
		movl	%eax,16(%esp)
		movl	%ecx,20(%esp)
		movl	(%esi),%eax
		movl	4(%esi),%ecx
		movl	%eax,8(%esp)
		movl	%ecx,12(%esp)
		movl	%esi,(%esp)
		call	blowfish_decrypt
		movl	(%esi),%eax
		movl	4(%esi),%ecx
		xorl	16(%esp),%eax
		xorl	20(%esp),%ecx
		movl	%eax,(%esi)
		movl	%ecx,4(%esi)
		addl	$8,%esi
		decl	%ebx
		jnz	deccbcloop
deccbcdone:	addl	$24,%esp
		popl	%esi
		popl	%ebx
		ret

/* int datarecv(WORD08 *data,WORD32 max,VPN *anchor)  */

.globl datarecv
		.type	datarecv,@function
		.align	16
datarecv:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		movl	24(%esp),%esi
		subl	$3100,%esp

		leal	16(%esp),%ebx
		movl	%ebx,(%esp)
		movl	$4,4(%esp)
		movl	%esi,8(%esp)
		call	dorecv
		testl	%eax,%eax
		jz	datarecverr
		call	decrypt_cfb_64_8
		movzwl	18(%esp),%edi
		testl	%edi,%edi
		jnz	datarecvreg

		movb	cipher(%esi),%al
		testb	%al,%al
		jz	datarecverr
		leal	28(%esp),%ebx
		movb	mode(%esi),%al
		testb	%al,%al
		jnz	datarecvsvr

		movl	%ebx,(%esp)
		movl	$8,4(%esp)
		movl	%esi,8(%esp)
		call	dorecv
		testl	%eax,%eax
		jz	datarkeyerr
		call	decrypt_cfb_64_8
		movl	%ebx,(%esp)
		movl	$8,4(%esp)
		leal	24(%esp),%ecx
		movl	%ecx,8(%esp)
		call	checksum
		movw	16(%esp),%ax
		cmpw	24(%esp),%ax
		jnz	datarkeyerr
		movl	local(%esi),%eax
		movl	%eax,remote(%esi)
		jmp	datarecvkey

datarecvsvr:	movl	%ebx,(%esp)
		movl	$80,4(%esp)
		movl	%esi,8(%esp)
		call	dorecv
		testl	%eax,%eax
		jz	datarkeyerr
		call	decrypt_cfb_64_8
		movl	%ebx,(%esp)
		movl	$80,4(%esp)
		leal	24(%esp),%ecx
		movl	%ecx,8(%esp)
		call	checksum
		movw	16(%esp),%ax
		cmpw	24(%esp),%ax
		jnz	datarkeyerr
		leal	sched1(%esi),%eax
		cmpl	remote(%esi),%eax
		jnz	datarkeys1
		leal	sched2(%esi),%eax
datarkeys1:	movl	%eax,remote(%esi)
		movl	%eax,8(%esp)
		movzwl	keysize(%esi),%eax
		movl	%eax,4(%esp)
		leal	8(%ebx),%eax
		movl	%eax,(%esp)
		call	blowfish_key_schedule

datarecvkey:	lea	remote_iv(%esi),%ecx
		movl	(%ebx),%eax
		movl	4(%ebx),%edx
		movl	%eax,(%ecx)
		movl	%edx,4(%ecx)
		xorl	%eax,%eax
		incl	%eax
		jmp	datarkeydone

datarkeyerr:	xorl	%eax,%eax

datarkeydone:	xorl	%edx,%edx
		xorl	%ecx,%ecx
datarecvclr:	movl	%edx,(%ebx,%ecx,4)
		incb	%cl
		cmpb	$20,%cl
		jne	datarecvclr
		jmp	datarecvdone
datarecvreg:	
.ifdef COMPRESS
		movl	%edi,%ecx
		andw	$32767,%edi
.endif
		movl	3120(%esp),%eax
		cmpl	%edi,%eax
		jnae	datarecverr
.ifdef COMPRESS
		cmpw	$8000,%cx
		jnae	datarecvnc
		movl	%eax,20(%esp)
		lea	28(%esp),%ebx
		movl	%ebx,(%esp)
		movl	%edi,4(%esp)
		movl	%esi,8(%esp)
		call	dorecv
		testl	%eax,%eax
		jz	datarecverr
		call	decrypt_cfb_64_8
		movl	%ebx,(%esp)
		movl	%edi,4(%esp)
		leal	24(%esp),%ecx
		movl	%ecx,8(%esp)
		call	checksum
		movl	%ebx,8(%esp)
		movl	3116(%esp),%ebx
		movl	%ebx,(%esp)
		leal	20(%esp),%eax
		movl	%eax,4(%esp)
		movl	%edi,12(%esp)
		call	uncompress
		testl	%eax,%eax
		jnz	datarecverr
		movl	20(%esp),%edi
		jmp	datarecvcmn
.endif
datarecvnc:	movl	3116(%esp),%ebx
		movl	%ebx,(%esp)
		movl	%edi,4(%esp)
		movl	%esi,8(%esp)
		call	dorecv
		testl	%eax,%eax
		jz	datarecverr
		call	decrypt_cfb_64_8
		movl    %ebx,(%esp)
		movl	%edi,4(%esp)
		leal	24(%esp),%ecx
		movl	%ecx,8(%esp)
		call	checksum
datarecvcmn:	leal	1(%edi),%eax
		movw	16(%esp),%bx
		cmpw	24(%esp),%bx
		jz	datarecvdone

datarecverr:	xorl	%eax,%eax

datarecvdone:	addl	$3100,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

/* int datasend(WORD08 *data,WORD32 max)  */

.globl datasend
		.type	datasend,@function
		.align	16
datasend:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		pushl	%ebp
		movl	20(%esp),%ebx
		movl	24(%esp),%edi
		movl	28(%esp),%ebp
		subl	$3100,%esp

		testl	%edi,%edi
		jnz	datasendreg

		movb	cipher(%ebp),%al
		testb	%al,%al
		jz	datasenderr
		lea	20(%esp),%esi
		leal	28(%esp),%ebx
		movl	%edi,(%esi)
		movb	mode(%ebp),%al
		testb	%al,%al
		jnz	datasendcln

		movl	%ebx,(%esp)
		movl	$80,4(%esp)
		movl	%ebp,8(%esp)
		call	getrandom
		testl	%eax,%eax
		jz	dataskeyerr
		movl	local(%ebp),%eax
		movl	%eax,4(%esp)
dataskeyloop:	leal	(%ebx,%edi,4),%eax
		movl	%eax,(%esp)
		call	blowfish_encrypt
		movl	(%ebx,%edi,4),%eax
		movl	4(%ebx,%edi,4),%ecx
		movl	%eax,80(%ebx,%edi,4)
		movl	%ecx,84(%ebx,%edi,4)
		addl	$2,%edi
		cmpl	$20,%edi
		jne	dataskeyloop
		movl	%ebx,(%esp)
		movl	$80,4(%esp)
		movl	%esi,8(%esp)
		call	checksum
		movl	%esi,(%esp)
		movl	$4,4(%esp)
		movl	%ebp,8(%esp)
		call	encrypt_cfb_64_8
		call	dosend
		testl	%eax,%eax
		jz	dataskeyerr
		movl	%ebx,(%esp)
		movl	$80,4(%esp)
		movl	%ebp,8(%esp)
		call	encrypt_cfb_64_8
		call	dosend
		testl	%eax,%eax
		jz	dataskeyerr
		leal	sched1(%ebp),%eax
		cmpl	local(%ebp),%eax
		jnz	dataskeys1
		leal	sched2(%ebp),%eax
dataskeys1:	movl	%eax,local(%ebp)
		movl	%eax,8(%esp)
		movzwl	keysize(%ebp),%eax
		movl	%eax,4(%esp)
		leal	88(%ebx),%eax
		movl	%eax,(%esp)
		call	blowfish_key_schedule
		jmp	dataskeycmn

datasendcln:	movl	%ebx,(%esp)
		movl	$8,4(%esp)
		movl	%ebp,8(%esp)
		call	getrandom
		testl	%eax,%eax
		jz	dataskeyerr
		movl	%ebx,(%esp)
		movl	local(%ebp),%eax
		movl	%eax,4(%esp)
		call	blowfish_encrypt
		movl	%ebx,(%esp)
		movl	$8,4(%esp)
		movl	%esi,8(%esp)
		call	checksum
		movl	(%ebx),%eax
		movl	4(%ebx),%ecx
		movl	%eax,80(%ebx)
		movl	%ecx,84(%ebx)
		movl	%esi,(%esp)
		movl	$4,4(%esp)
		movl	%ebp,8(%esp)
		call	encrypt_cfb_64_8
		call	dosend
		testl	%eax,%eax
		jz	dataskeyerr
		movl	%ebx,(%esp)
		movl	$8,4(%esp)
		movl	%ebp,8(%esp)
		call	encrypt_cfb_64_8
		call	dosend
		testl	%eax,%eax
		jz	dataskeyerr
		movl	remote(%ebp),%eax
		movl	%eax,local(%ebp)

dataskeycmn:	leal	local_iv(%ebp),%eax
		movl	80(%ebx),%ecx
		movl	84(%ebx),%edx
		movl	%ecx,(%eax)
		movl	%edx,4(%eax)
		xorl	%eax,%eax
		incl	%eax
		jmp	dataskeydone

dataskeyerr:	xorl	%eax,%eax

dataskeydone:	xorl	%edx,%edx
		xorl	%ecx,%ecx
datasendclr:	movl	%edx,(%ebx,%ecx,4)
		movl	%edx,80(%ebx,%ecx,4)
		incb	%cl
		cmpb	$20,%cl
		jne	datasendclr
		jmp	datasenddone

datasendreg:	cmpl	$2049,%edi
		jnb	datasenderr
		movw	%di,22(%esp)
.ifdef COMPRESS
		movb	peercomp(%ebp),%al
		testb	%al,%al
		jnz	datasendnc
		movb	nocompress(%ebp),%al
		testb	%al,%al
		jnz	datasendnc
		cmpw	threshold(%ebp),%di
		jnae	datasendnc
		lea	28(%esp),%esi
		movl	%esi,(%esp)
		leal	24(%esp),%ecx
		movl	$3072,%eax
		movl	%eax,(%ecx)
		movl	%ecx,4(%esp)
		movl	%ebx,8(%esp)
		movl	%edi,12(%esp)
		movl	$9,%eax
		movl	%eax,16(%esp)
		call	compress2
		testl	%eax,%eax
		jnz	datasendnc
		movl	24(%esp),%eax
		cmpl	%eax,%edi
		jna	datasendnc
		movl	%eax,%edi
		movl	%esi,%ebx
		orw	$32768,%ax
		movw	%ax,22(%esp)
.endif
datasendnc:	movl	%ebx,(%esp)
		movl	%edi,4(%esp)
		leal	20(%esp),%eax
		movl	%eax,8(%esp)
		call	checksum
		leal	20(%esp),%eax
		movl	%eax,(%esp)
		movl	$4,4(%esp)
		movl	%ebp,8(%esp)
		call	encrypt_cfb_64_8
		call	dosend
		testl	%eax,%eax
		jz	datasenderr
		movl	%ebx,(%esp)
		movl	%edi,4(%esp)
		movl	%ebp,8(%esp)
		call	encrypt_cfb_64_8
		call	dosend
		testl	%eax,%eax
		jz	datasenderr
		xorl	%eax,%eax
		incl	%eax
		jmp	datasenddone

datasenderr:	xorl	%eax,%eax

datasenddone:	addl	$3100,%esp
		popl	%ebp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

