/*
 * virtual private network daemon (vpnd)
 *
 * cryptographic stuff (c) 1999 Andreas Steinmetz, astmail@yahoo.com
 * other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz
 *
 * License:
 * This code is in the public domain (*) under the GNU public license.
 * The copyright holders will however retain their copyright.
 * There is no guarantee for the fitness and usability of this code
 * for any purpose. The author and the copyright holders take no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 */

#include "vpnd.h"

/*============================================================================*/
/* the graveyard: clean up and process termination                            */
/*============================================================================*/

/*
 * closehandles
 *
 * This procedure closes all open handles.
 */

void closehandles(void)
{
	VPN *rover=&globals;	/* pointer to global data	*/


	/* debug message */

	ENTER("closehandles");

	/* for all configuration sets */

	while(rover)
	{
		/* close all open handles */

		if(rover->tty!=-1)close(rover->tty);
		if(rover->pty!=-1)close(rover->pty);
		if(rover->peer!=-1)close(rover->peer);
		if(rover->server!=-1)close(rover->server);
		if(rover->serial!=-1)close(rover->serial);

		/* mark handles as closed */

		rover->slip=0;
		rover->tty=rover->pty=rover->peer=rover->server=
			rover->serial=-1;

		/* next configuration set */

		 rover=rover->next;
	}

	/* debug message */

	LEAVE("closehandles");
}

/*
 * clearmem
 *
 * This procedure resets all memory to prevent spoofing.
 */

void clearmem(void)
{
	VPN *anchor=&globals;	/* pointer to global data	*/
	VPN *next;		/* pointer to global data	*/


	/* debug message */

	ENTER("clearmem");

	/* for all configuration sets */

	while(anchor)
	{
		/* memorize pointer to next configuration set */

		next=anchor->next;

		/* clean up */

		memset(anchor,0,sizeof(VPN));

		/* next configuration data set */

		anchor=next;
	}

	/* debug message */

	LEAVE("clearmem");
}

/*
 * die
 *
 * input: rval  - the process termination value
 *	  slave - 1 if slave process, 0 if main process
 *
 * This procedure does a final clean up and then exits. It never returns.
 */

void die(int rval,int slave)
{
	VPN *anchor=&globals;	/* pointer to global data	*/


	/* debug message */

	ENTER("die");

	/* for all configuration sets */

	while(anchor)
	{
		/* kill init chat child if any */

		if(anchor->child)if(kill(anchor->child,SIGTERM))ERRNO("kill");

		/* if not in slave mode */

		if(!slave)
		{
			/* shut down slip interface if up */

			sliphandler(!anchor->cipher&&anchor->serialmode?3:2,
				anchor);

			/* disconnect from peer if connected,
				close server socket if there is any */

			disconnect(2,anchor);

			/* close open serial line if open */

			if(anchor->serial!=-1)serialhandler(anchor);
		}

		/* next set */

		anchor=anchor->next;
	}

	/* slave process closes all open handles */

	if(slave)closehandles();

	/* reset memory */

	clearmem();

	/* print info, if not child process */

	if(!slave)logmsg(SHUTDOWN,0,NULL);

	/* end logging */

	closelog();

	/* if not slave process remove pid file if used */

	if(!slave)if(pidfile)if(unlink(pidfile))ERRNO("unlink");

	/* debug message */

	LEAVE("die");

	/* exit process */

	exit(rval);
}
