/* RIPEMD-160 Production Implementation                                       */
/* This implementation: (c) 1999 Andreas Steinmetz                            */
/* RIPEMD-160 algorithm by Hans Dobbertin, Antoon Bosselaers and Bart Preneel,*/
/* see http://www.esat.kuleuven.ac.be/~bosselae/ripemd160.html                */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2286                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact astmail@yahoo.com           */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation is processor independent.                     */
/* It does not depend on any run time library and                             */
/* should be 64 bit clean.                                                    */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the RIPEMD-160 routines.                        */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for RMD160 transformation   WORD08[64]                          */
/* resulting RMD160 or HMAC hash          WORD08[20]                          */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* RMD160_FULL defined:                                                       */
/*                                                                            */
/* 1. Call rmd160init                                                         */
/* 2. For all data to be hashed call rmd160next                               */
/* 3. To retrieve the hash call rmd160end                                     */
/*                                                                            */
/* RMD160_FAST defined:                                                       */
/*                                                                            */
/* Call rmd160 to get the hash for the specified data                         */
/*                                                                            */
/* RMD160_HMAC_FULL defined:                                                  */
/*                                                                            */
/* 1. Call rmd160hmkey once to preprocess the selected key                    */
/* 2. Call rmd160hminit                                                       */
/* 3. For all data to be hashed call rmd160hmnext                             */
/* 4. To retrieve the hash call rmd160hmend                                   */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the RMD160HMDATA structure                                        */
/*                                                                            */
/* RMD160_HMAC_FAST defined:                                                  */
/*                                                                            */
/* 1. Call rmd160hmkey once to preprocess the selected key                    */
/* 2. Call rmd160hmac to get the hash for the specified data                  */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the RMD160HMDATA structure                                        */

.text

.ifdef  RMD160_HMAC_FULL
                _RMD160_HMAC=1
.endif
.ifdef  RMD160_HMAC_FAST
                _RMD160_HMAC=1
.endif
.ifdef  RMD160_FULL
                _RMD160_FULL=1
.endif
.ifdef  _RMD160_HMAC
                _RMD160_FULL=1
                RMD160_PARANOID=1
.endif

/* static void rmd160block(WORD32 *rmd160,WORD08 *block) */

		.align	16
rmd160block:
		pushl	%ebx
		pushl	%esi
		pushl	%edi
		pushl	%ebp
		leal	rmdtab,%esi
		subl	$84,%esp

		movl	108(%esp),%ebx
		movl	%esp,%ecx
		xorl	%edx,%edx
precopy:	movl	(%ebx,%edx,4),%eax
		movl	%eax,(%ecx,%edx,4)
		incl	%edx
		cmpl	$16,%edx
		jne	precopy

		movl	104(%esp),%ecx
		movl	(%ecx),%eax
		movl	4(%ecx),%ebx
		movl	8(%ecx),%edx
		movl	12(%ecx),%edi
		movl	16(%ecx),%ebp

		movl	$16,%ecx
round1:		pushl	%ecx
		movl	%ebx,%ecx
		xorl	%edx,%ecx
		xorl	%edi,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	round1

		movl	$16,%ecx
round2:		pushl	%ecx
		addl	$0x5a827999,%eax
		movl	%edi,%ecx
		xorl	%edx,%ecx
		andl	%ebx,%ecx
		xorl	%edi,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	round2

		movl	$16,%ecx
round3:		pushl	%ecx
		addl	$0x6ed9eba1,%eax
		movl	%edx,%ecx
		notl	%ecx
		orl	%ebx,%ecx
		xorl	%edi,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	round3

		movl	$16,%ecx
round4:		pushl	%ecx
		addl	$0x8f1bbcdc,%eax
		movl	%edx,%ecx
		xorl	%ebx,%ecx
		andl	%edi,%ecx
		xorl	%edx,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	round4

		movl	$16,%ecx
round5:		pushl	%ecx
		addl	$0xa953fd4e,%eax
		movl	%edi,%ecx
		notl	%ecx
		orl	%edx,%ecx
		xorl	%ebx,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	round5

		leal	64(%esp),%ecx
		movl	%eax,(%ecx)
		movl	%ebx,4(%ecx)
		movl	%edx,8(%ecx)
		movl	%edi,12(%ecx)
		movl	%ebp,16(%ecx)

		movl	104(%esp),%ecx
		movl	(%ecx),%eax
		movl	4(%ecx),%ebx
		movl	8(%ecx),%edx
		movl	12(%ecx),%edi
		movl	16(%ecx),%ebp

		movl	$16,%ecx
pround1:	pushl	%ecx
		addl	$0x50a28be6,%eax
		movl	%edi,%ecx
		notl	%ecx
		orl	%edx,%ecx
		xorl	%ebx,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	pround1

		movl	$16,%ecx
pround2:	pushl	%ecx
		addl	$0x5c4dd124,%eax
		movl	%edx,%ecx
		xorl	%ebx,%ecx
		andl	%edi,%ecx
		xorl	%edx,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	pround2

		movl	$16,%ecx
pround3:	pushl	%ecx
		addl	$0x6d703ef3,%eax
		movl	%edx,%ecx
		notl	%ecx
		orl	%ebx,%ecx
		xorl	%edi,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	pround3

		movl	$16,%ecx
pround4:	pushl	%ecx
		addl	$0x7a6d76e9,%eax
		movl	%edi,%ecx
		xorl	%edx,%ecx
		andl	%ebx,%ecx
		xorl	%edi,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	pround4

		movl	$16,%ecx
pround5:	pushl	%ecx
		movl	%ebx,%ecx
		xorl	%edx,%ecx
		xorl	%edi,%ecx
		addl	%ecx,%eax
		movzbl	(%esi),%ecx
		roll	$10,%edx
		addl	4(%esp,%ecx,4),%eax
		incl	%esi
		movzbl	(%esi),%ecx
		roll	%cl,%eax
		incl	%esi
		movl	%ebp,%ecx
		addl	%ecx,%eax
		movl	%edi,%ebp
		movl	%edx,%edi
		movl	%ebx,%edx
		movl	%eax,%ebx
		movl	%ecx,%eax
		popl	%ecx
		decl	%ecx
		jne	pround5

		leal	64(%esp),%ecx
		addl	16(%ecx),%eax
		addl	(%ecx),%ebx
		addl	4(%ecx),%edx
		addl	8(%ecx),%edi
		addl	12(%ecx),%ebp

		movl	104(%esp),%ecx
		addl	12(%ecx),%eax
		addl	16(%ecx),%ebx
		addl	(%ecx),%edx
		addl	4(%ecx),%edi
		addl	8(%ecx),%ebp

		addl	$84,%esp
		movl	%eax,8(%ecx)
		movl	%edx,16(%ecx)
		movl	%ebp,4(%ecx)
		popl	%ebp
		movl	%edi,(%ecx)
		popl	%edi
		movl	%ebx,12(%ecx)

		popl	%esi
		popl	%ebx
		ret

/* void rmd160init(RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160init
		.type	rmd160init,@function
		.align	16
rmd160init:	leal	rmd160start,%edx
		movl	4(%esp),%ecx
		pushl	%ebx
		xorl	%ebx,%ebx
rmd160initlp1:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	rmd160initlp1
		popl	%ebx
		xorl	%eax,%eax
		movl	%eax,20(%ecx)
		movb	%al,88(%ecx)
		ret

.endif

/* void rmd160next(WORD08 *data,WORD32 length,RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160next
		.type	rmd160next,@function
		.align	16
rmd160next:	pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$8,%esp

		movl	36(%esp),%esi
		movl	32(%esp),%edi
		movl	28(%esp),%ebp

		movl	%esi,(%esp)
		addl	%edi,20(%esi)

		movzbl	88(%esi),%ebx
		testl	%edi,%edi
		je	rmd160nextlp2
rmd160nextlp1:	testl	%ebx,%ebx
		je	rmd160nextlp2
		movb	(%ebp),%al
		movb	%al,24(%esi,%ebx,)
		incl	%ebp
		incl	%ebx
		cmpl	$64,%ebx
		jne	rmd160nextct1
		xorl	%ebx,%ebx
		leal	24(%esi),%eax
		movl	%eax,4(%esp)
		call	rmd160block
rmd160nextct1:	decl	%edi
		jne	rmd160nextlp1

rmd160nextlp2:	cmpl	$64,%edi
		jnae	rmd160nxlp2end
		movl	%ebp,4(%esp)
		call	rmd160block
		addl	$64,%ebp
		subl	$64,%edi
		jmp	rmd160nextlp2

rmd160nxlp2end:	testl	%edi,%edi
		je	rmd160nextend

rmd160nextlp3:	movb	(%ebp),%al
		movb	%al,24(%esi,%ebx,)
		incl	%ebp
		incl	%ebx
		decl	%edi
		jne	rmd160nextlp3

rmd160nextend:	movb	%bl,88(%esi)

		addl	$8,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void rmd160end(WORD08 *result,RMD160DATA *ptr) */

.ifdef _RMD160_FULL

.globl rmd160end
		.type	rmd160end,@function
		.align	16
rmd160end:		pushl	%ebx
		pushl	%esi
		pushl	%edi
		subl	$8,%esp

		movl	28(%esp),%esi
		movl	24(%esp),%edi

		movl	%esi,(%esp)
		leal	24(%esi),%eax
		movl	%eax,4(%esp)

		movzbl	88(%esi),%ebx
		movb	$128,%al
rmd160endloop1:	movb	%al,24(%esi,%ebx,)
		xorl	%eax,%eax
		incl	%ebx
		cmpl	$56,%ebx
		je	rmd160ndlp1end
		cmpl	$64,%ebx
		jne	rmd160endloop1
		movl	%eax,%ebx
		call	rmd160block
		movl	%ebx,%eax
		jmp	rmd160endloop1

rmd160ndlp1end:	movl	20(%esi),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,24(%esi,%ebx,)
		movl	%ecx,28(%esi,%ebx,)
		call	rmd160block

		xorl	%ebx,%ebx
rmd160endloop2:	movl	(%esi,%ebx,4),%eax
		movl	%eax,(%edi,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	rmd160endloop2

.ifdef RMD160_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
rmd160endloop3:	movl	%eax,24(%esi)
		addl	$4,%esi
		decl	%ebx
		jne	rmd160endloop3

.endif

		addl	$8,%esp
		popl	%edi
		popl	%esi
		popl	%ebx
		ret

.endif

/* void rmd160(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef RMD160_FAST

.globl rmd160
		.type	rmd160,@function
		.align	16
rmd160:		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$92,%esp

		leal	8(%esp),%ecx
		leal	rmd160start,%edx
		movl	%ecx,(%esp)
		xorl	%ebx,%ebx
rmd160loop1:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	rmd160loop1

		movl	116(%esp),%edi
		movl	112(%esp),%ebp
rmd160loop2:	cmpl	$64,%edi
		jnae	rmd160loop2end
		movl	%ebp,4(%esp)
		call	rmd160block
		addl	$64,%ebp
		subl	$64,%edi
		jmp	rmd160loop2

rmd160loop2end:	leal	28(%esp),%esi
		movl	%esi,4(%esp)
		xorl	%ebx,%ebx
		testl	%edi,%edi
		je	rmd160loop3end

rmd160loop3:	movb	(%ebp,%ebx,),%al
		movb	%al,(%esi,%ebx,)
		incl	%ebx
		decl	%edi
		jne	rmd160loop3

rmd160loop3end:	movb	$128,%al
rmd160loop4:	movb	%al,(%esi,%ebx,)
		xorl	%eax,%eax
		inc	%ebx
		cmpl	$56,%ebx
		je	rmd160loop4end
		cmpl	$64,%ebx
		jne	rmd160loop4
		movl	%eax,%ebx
		call	rmd160block
		movl	%ebx,%eax
		jmp	rmd160loop4

rmd160loop4end:	movl	116(%esp),%edx
		movl	%edx,%ecx
		shll	$3,%edx
		shrl	$29,%ecx
		movl	%edx,(%esi,%ebx,)
		movl	%ecx,4(%esi,%ebx,)
		call	rmd160block

		movl	(%esp),%edx
		movl	120(%esp),%ecx
		xorl	%ebx,%ebx
rmd160loop5:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	rmd160loop5

.ifdef RMD160_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
rmd160loop6:	movl	%eax,(%esi)
		addl	$4,%esi
		decl	%ebx
		jne	rmd160loop6

.endif

		addl	$92,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void rmd160hmkey(WORD08 *key,WORD32 keylength,RMD160HMDATA *ptr) */

.ifdef	_RMD160_HMAC

.globl rmd160hmkey
		.type	rmd160hmkey,@function
		.align	16
rmd160hmkey:	pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi

		movl	20(%esp),%ebp
		movl	24(%esp),%esi
		movl	28(%esp),%edi

		subl	$124,%esp

		cmpl	$65,%esi
		jnae	rmd160hmkey1
		leal	12(%esp),%ebx
		movl	%ebx,(%esp)
		call	rmd160init
		movl	%ebp,(%esp)
		movl	%esi,4(%esp)
		movl	%ebx,8(%esp)
		call	rmd160next
		leal	104(%esp),%ebp
		movl	%ebp,(%esp)
		movl	%ebx,4(%esp)
		call	rmd160end
		movl	$20,%esi
		xorl	%eax,%eax
		movl	$5,%edx
rmd160hmkeylp1:	movl	%eax,(%ebx)
		addl	$4,%ebx
		decl	%edx
		jne	rmd160hmkeylp1

rmd160hmkey1:	xorl	%ecx,%ecx
		leal	rmd160start,%edx
rmd160hmkeylp2:	movl	(%edx,%ecx,4),%eax
		movl	%eax,(%edi,%ecx,4)
		movl	%eax,20(%edi,%ecx,4)
		incl	%ecx
		cmpl	$5,%ecx
		jne	rmd160hmkeylp2

		leal	12(%esp),%ebx
		movl	%ebx,4(%esp)

		xorl	%ecx,%ecx
		movb	$54,%dl
		jmp	rmd160hmkey2
rmd160hmkeylp3:	movb	(%ebp,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%ebx,%ecx,)
		incl	%ecx
rmd160hmkey2:	cmpl	%ecx,%esi
		jne	rmd160hmkeylp3

		jmp	rmd160hmkey3
rmd160hmkeylp4:	movb	%dl,(%ebx,%ecx,)
		incl	%ecx
rmd160hmkey3:	cmpl	$64,%ecx
		jne	rmd160hmkeylp4

		movl	%edi,(%esp)
		call	rmd160block

		xorl	%ecx,%ecx
		movb	$92,%dl
		jmp	rmd160hmkey4
rmd160hmkeylp5:	movb	(%ebp,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%ebx,%ecx,)
		incl	%ecx
rmd160hmkey4:	cmpl	%ecx,%esi
		jne	rmd160hmkeylp5

		jmp	rmd160hmkey5
rmd160hmkeylp6:	movb	%dl,(%ebx,%ecx,)
		incl	%ecx
rmd160hmkey5:	cmpl	$64,%ecx
		jne	rmd160hmkeylp6

		addl	$20,(%esp)
		call	rmd160block

		leal	12(%esp),%ebx
		leal	104(%esp),%ecx
		xorl	%edx,%edx
		xorl	%eax,%eax
rmd160hmkeylp7:	movl	%eax,(%ebx,%edx,4)
		movb	%al,(%ecx,%edx,)
		incl	%edx
		cmpl	$20,%edx
		jne	rmd160hmkeylp7

		addl	$124,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void rmd160hminit(RMD160DATA *ptr,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FULL

.globl rmd160hminit
		.type	rmd160hminit,@function
		.align	16
rmd160hminit:	xorl	%edx,%edx
		pushl	%ebx
		movl	8(%esp),%ebx
		movl	12(%esp),%ecx
		movb	%dl,88(%ebx)
rmd160hminitlp:	movl	(%ecx,%edx,4),%eax
		movl	%eax,(%ebx,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	rmd160hminitlp
		movl	$64,%edx
		movl	%edx,20(%ebx)
		popl	%ebx
		ret

.endif

/* void rmd160hmend(WORD08 *result,RMD160DATA *ptr,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FULL

.globl rmd160hmend
		.type	rmd160hmend,@function
		.align	16
rmd160hmend:	pushl	%ebx
		pushl	%esi
		subl	$12,%esp
		movl	%esp,%esi
		movl	24(%esi),%eax
		movl	%eax,(%esi)
		movl	28(%esi),%ebx
		movl	%ebx,4(%esi)
		call	rmd160end
		movl	32(%esi),%ecx
		xorl	%edx,%edx
		movb	%dl,88(%ebx)
rmd160hmendlp:	movl	20(%ecx,%edx,4),%eax
		movl	%eax,(%ebx,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	rmd160hmendlp
		movl	$64,%edx
		movl	%edx,20(%ebx)
		movl	$20,%edx
		movl	%edx,4(%esi)
		movl	%ebx,8(%esi)
		call	rmd160next
		movl	%ebx,4(%esi)
		call	rmd160end
		addl	$12,%esp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void rmd160hmac(WORD08 *data,WORD32 length,WORD08 *result,RMD160HMDATA *key) */

.ifdef	RMD160_HMAC_FAST

.globl rmd160hmac
		.type	rmd160hmac,@function
		.align	16
rmd160hmac:	xorl	%edx,%edx
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		movl	28(%esp),%ebx
		subl	$104,%esp
		movl	%esp,%esi
		leal	12(%esi),%edi
		movb	%dl,88(%edi)

rmd160hmaclp1:	movl	(%ebx,%edx,4),%eax
		movl	%eax,(%edi,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	rmd160hmaclp1
		movl	$64,%edx
		movl	%edx,20(%edi)

		movl	120(%esi),%eax
		movl	%eax,(%esi)
		movl	124(%esi),%eax
		movl	%eax,4(%esi)
		movl	%edi,8(%esi)
		call	rmd160next

		movl	128(%esi),%eax
		movl	%eax,(%esi)
		movl	%edi,4(%esi)
		call	rmd160end

		xorl	%edx,%edx
		movb	%dl,88(%edi)
rmd160hmaclp2:	movl	20(%ebx,%edx,4),%eax
		movl	%eax,(%edi,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	rmd160hmaclp2
		movl	$64,%edx
		movl	%edx,20(%edi)

		movl	$20,%edx
		movl	%edx,4(%esi)
		call	rmd160next

		movl	%edi,4(%esi)
		call	rmd160end

		addl	$104,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

.endif

.data
		.align	16
rmd160start:	.long	0x67452301,0xefcdab89,0x98badcfe
		.long	0x10325476,0xc3d2e1f0

		.align	16
rmdtab:		.byte	 0,11, 1,14, 2,15, 3,12, 4, 5, 5, 8, 6, 7, 7, 9
		.byte	 8,11, 9,13,10,14,11,15,12, 6,13, 7,14, 9,15, 8
		.byte	 7, 7, 4, 6,13, 8, 1,13,10,11, 6, 9,15, 7, 3,15
		.byte	12, 7, 0,12, 9,15, 5, 9, 2,11,14, 7,11,13, 8,12
		.byte	 3,11,10,13,14, 6, 4, 7, 9,14,15, 9, 8,13, 1,15
		.byte	 2,14, 7, 8, 0,13, 6, 6,13, 5,11,12, 5, 7,12, 5
		.byte	 1,11, 9,12,11,14,10,15, 0,14, 8,15,12, 9, 4, 8
		.byte	13, 9, 3,14, 7, 5,15, 6,14, 8, 5, 6, 6, 5, 2,12
		.byte	 4, 9, 0,15, 5, 5, 9,11, 7, 6,12, 8, 2,13,10,12
		.byte	14, 5, 1,12, 3,13, 8,14,11,11, 6, 8,15, 5,13, 6
		.byte	 5, 8,14, 9, 7, 9, 0,11, 9,13, 2,15,11,15, 4, 5
		.byte	13, 7, 6, 7,15, 8, 8,11, 1,14,10,14, 3,12,12, 6
		.byte	 6, 9,11,13, 3,15, 7, 7, 0,12,13, 8, 5, 9,10,11
		.byte	14, 7,15, 7, 8,12,12, 7, 4, 6, 9,15, 1,13, 2,11
		.byte	15, 9, 5, 7, 1,15, 3,11, 7, 8,14, 6, 6, 6, 9,14
		.byte	11,12, 8,13,12, 5, 2,14,10,13, 0,13, 4, 7,13, 5
		.byte	 8,15, 6, 5, 4, 8, 1,11, 3,14,11,14,15, 6, 0,14
		.byte	 5, 6,12, 9, 2,12,13, 9, 9,12, 7, 5,10,15,14, 8
		.byte	12, 8,15, 5,10,12, 4, 9, 1,12, 5, 5, 8,14, 7, 6
		.byte	 6, 8, 2,13,13, 6,14, 5, 0,15, 3,13, 9,11,11,11

