/* SHA1 Production Implementation                                             */
/* This implementation: (c) 1999 Andreas Steinmetz                            */
/* SHA1 algorithm: see FIPS PUB 180-1                                         */
/* HMAC algorithm by Krawczyk, et. al., see RFC2104                           */
/* Test cases for HMAC: see RFC2202                                           */
/*                                                                            */
/* License:                                                                   */
/* This code is under the GNU public license                                  */
/* for use with the virtual private network daemon (vpnd).                    */
/* The copyright holder will however retain the copyright.                    */
/* In addition to vpnd this code may be used                                  */
/* for all GPL/LGPL based open source software products.                      */
/* For all other software products please contact astmail@yahoo.com           */
/* for a license agreement. There is no guarantee for the fitness             */
/* and usability of this code for any purpose. The author takes no            */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/*                                                                            */
/* This implementation is tuned for speed.                                    */
/*                                                                            */
/* Note that the implementation is processor independent.                     */
/* It does not depend on any run time library and                             */
/* should be 64 bit clean.                                                    */
/*                                                                            */
/* Restriction:                                                               */
/*                                                                            */
/* The maximum data length to be processed is 2^32-1 bytes but                */
/* this shouldn't be an issue for nearly all applications. If                 */
/* it is an issue you will have to extend the variable 'total'                */
/* from 32 bits to 64 bits in the SHA1 routines.                              */
/*                                                                            */
/* Data sizes:                                                                */
/*                                                                            */
/* data block for SHA1 transformation   WORD08[64]                            */
/* resulting SHA1 or HMAC hash          WORD08[20]                            */
/*                                                                            */
/* WORD08 means an unsigned word of 8 bits length                             */
/* WORD32 means an unsigned word of at least 32 bits length                   */
/*                                                                            */
/* Mode of operation:                                                         */
/*                                                                            */
/* SHA1_FULL defined:                                                         */
/*                                                                            */
/* 1. Call sha1init                                                           */
/* 2. For all data to be hashed call sha1next                                 */
/* 3. To retrieve the hash call sha1end                                       */
/*                                                                            */
/* SHA1_FAST defined:                                                         */
/*                                                                            */
/* Call sha1 to get the hash for the specified data                           */
/*                                                                            */
/* SHA1_HMAC_FULL defined:                                                    */
/*                                                                            */
/* 1. Call sha1hmkey once to preprocess the selected key                      */
/* 2. Call sha1hminit                                                         */
/* 3. For all data to be hashed call sha1hmnext                               */
/* 4. To retrieve the hash call sha1hmend                                     */
/* 5. When the preprocessed key is no longer required                         */
/*    reset the SHA1HMDATA structure                                          */
/*                                                                            */
/* SHA1_HMAC_FAST defined:                                                    */
/*                                                                            */
/* 1. Call sha1hmkey once to preprocess the selected key                      */
/* 2. Call sha1hmac to get the hash for the specified data                    */
/* 3. When the preprocessed key is no longer required                         */
/*    reset the SHA1HMDATA structure                                          */

.text

.ifdef  SHA1_HMAC_FULL
                _SHA1_HMAC=1
.endif
.ifdef  SHA1_HMAC_FAST
                _SHA1_HMAC=1
.endif
.ifdef  SHA1_FULL
                _SHA1_FULL=1
.endif
.ifdef  _SHA1_HMAC
                _SHA1_FULL=1
                SHA1_PARANOID=1
.endif

/* static void sha1block(WORD32 *sha1,WORD08 *block) */

		.align	16
sha1block:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		pushl	%ebp

		movl	20(%esp),%eax
		movl	24(%esp),%esi
		subl	$320,%esp

		movl	$16,%ebx
		movl	%esp,%ecx
loop_0_16:	movl	(%esi),%edx
		bswapl	%edx
		movl	%edx,(%ecx)
		addl	$4,%esi
		addl	$4,%ecx
		decl	%ebx
		jne	loop_0_16

		movl	$64,%ebx
loop_16_80:	movl	-12(%ecx),%edx
		xorl	-32(%ecx),%edx
		xorl	-56(%ecx),%edx
		xorl	-64(%ecx),%edx
		roll	$1,%edx
		movl	%edx,(%ecx)
		addl	$4,%ecx
		decl	%ebx
		jne	loop_16_80
		
		movl	(%eax),%ecx
		movl	4(%eax),%esi
		movl	8(%eax),%ebp
		movl	12(%eax),%edi
		movl	16(%eax),%edx

		movl	$20,%ebx
loop_0_20:	movl	%ecx,%eax
		roll	$5,%eax
		addl	%eax,%edx
		popl	%eax
		addl	$0x5a827999,%edx
		addl	%eax,%edx
		movl	%ebp,%eax
		xorl	%edi,%eax
		andl	%esi,%eax
		xorl	%edi,%eax
		addl	%edx,%eax
		rorl	$2,%esi
		movl	%edi,%edx
		movl	%ebp,%edi
		movl	%esi,%ebp
		movl	%ecx,%esi
		movl	%eax,%ecx
		decl	%ebx
		jne	loop_0_20

		movl	$20,%ebx
loop_20_40:	movl	%ecx,%eax
		roll	$5,%eax
		addl	%eax,%edx
		popl	%eax
		addl	$0x6ed9eba1,%edx
		addl	%eax,%edx
		movl	%ebp,%eax
		xorl	%edi,%eax
		xorl	%esi,%eax
		addl	%edx,%eax
		rorl	$2,%esi
		movl	%edi,%edx
		movl	%ebp,%edi
		movl	%esi,%ebp
		movl	%ecx,%esi
		movl	%eax,%ecx
		decl	%ebx
		jne	loop_20_40

		movl	$20,%ebx
loop_40_60:	movl	%ecx,%eax
		roll	$5,%eax
		addl	%eax,%edx
		popl	%eax
		addl	$0x8f1bbcdc,%edx
		addl	%eax,%edx
		movl	%ebp,%eax
		pushl	%ebx
		andl	%esi,%eax
		movl	%ebp,%ebx
		orl	%esi,%ebx
		andl	%edi,%ebx
		orl	%ebx,%eax
		addl	%edx,%eax
		rorl	$2,%esi
		popl	%ebx
		movl	%edi,%edx
		movl	%ebp,%edi
		movl	%esi,%ebp
		movl	%ecx,%esi
		movl	%eax,%ecx
		decl	%ebx
		jne	loop_40_60

		movl	$20,%ebx
loop_60_80:	movl	%ecx,%eax
		roll	$5,%eax
		addl	%eax,%edx
		popl	%eax
		addl	$0xca62c1d6,%edx
		addl	%eax,%edx
		movl	%ebp,%eax
		xorl	%edi,%eax
		xorl	%esi,%eax
		addl	%edx,%eax
		rorl	$2,%esi
		movl	%edi,%edx
		movl	%ebp,%edi
		movl	%esi,%ebp
		movl	%ecx,%esi
		movl	%eax,%ecx
		decl	%ebx
		jne	loop_60_80

		movl	20(%esp),%eax
		addl	%ecx,(%eax)
		addl	%esi,4(%eax)
		addl	%ebp,8(%eax)
		addl	%edi,12(%eax)
		addl	%edx,16(%eax)

		popl	%ebp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

/* void sha1init(SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1init
		.type	sha1init,@function
		.align	16
sha1init:	leal	sha1start,%edx
		movl	4(%esp),%ecx
		pushl	%ebx
		xorl	%ebx,%ebx
sha1initloop1:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	sha1initloop1
		popl	%ebx
		xorl	%eax,%eax
		movl	%eax,20(%ecx)
		movb	%al,88(%ecx)
		ret

.endif

/* void sha1next(WORD08 *data,WORD32 length,SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1next
		.type	sha1next,@function
		.align	16
sha1next:	pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$8,%esp

		movl	36(%esp),%esi
		movl	32(%esp),%edi
		movl	28(%esp),%ebp

		movl	%esi,(%esp)
		addl	%edi,20(%esi)

		movzbl	88(%esi),%ebx
		testl	%edi,%edi
		je	sha1nextloop2
sha1nextloop1:	testb	%ebx,%ebx
		je	sha1nextloop2
		movb	(%ebp),%al
		movb	%al,24(%esi,%ebx,)
		incl	%ebp
		incl	%ebx
		cmpl	$64,%ebx
		jne	sha1nextcont1
		xorl	%ebx,%ebx
		leal	24(%esi),%eax
		movl	%eax,4(%esp)
		call	sha1block
sha1nextcont1:	decl	%edi
		jne	sha1nextloop1

sha1nextloop2:	cmpl	$64,%edi
		jnae	sha1nxloop2end
		movl	%ebp,4(%esp)
		call	sha1block
		addl	$64,%ebp
		subl	$64,%edi
		jmp	sha1nextloop2

sha1nxloop2end:	testl	%edi,%edi
		je	sha1nextend

sha1nextloop3:	movb	(%ebp),%al
		movb	%al,24(%esi,%ebx,)
		incl	%ebp
		incl	%ebx
		decl	%edi
		jne	sha1nextloop3

sha1nextend:	movb	%bl,88(%esi)

		addl	$8,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void sha1end(WORD08 *result,SHA1DATA *ptr) */

.ifdef _SHA1_FULL

.globl sha1end
		.type	sha1end,@function
		.align	16
sha1end:		pushl	%ebx
		pushl	%esi
		pushl	%edi
		subl	$8,%esp

		movl	28(%esp),%esi
		movl	24(%esp),%edi

		movl	%esi,(%esp)
		leal	24(%esi),%eax
		movl	%eax,4(%esp)

		movzbl	88(%esi),%ebx
		movb	$128,%al
sha1endloop1:	movb	%al,24(%esi,%ebx,)
		xorl	%eax,%eax
		incl	%ebx
		cmpl	$56,%ebx
		je	sha1ndloop1end
		cmpl	$64,%ebx
		jne	sha1endloop1
		movl	%eax,%ebx
		call	sha1block
		movl	%ebx,%eax
		jmp	sha1endloop1

sha1ndloop1end:	movl	20(%esi),%edx
		movl	%edx,%ecx
		shrl	$29,%ecx
		bswapl	%ecx
		shll	$3,%edx
		bswapl	%edx
		movl	%ecx,24(%esi,%ebx,)
		movl	%edx,28(%esi,%ebx,)
		call	sha1block

		xorl	%ebx,%ebx
sha1endloop2:	movl	(%esi,%ebx,4),%eax
		bswapl	%eax
		movl	%eax,(%edi,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	sha1endloop2

.ifdef SHA1_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
sha1endloop3:	movl	%eax,24(%esi)
		addl	$4,%esi
		decl	%ebx
		jne	sha1endloop3

.endif

		addl	$8,%esp
		popl	%edi
		popl	%esi
		popl	%ebx
		ret

.endif

/* void sha1(WORD08 *data,WORD32 length,WORD08 *result) */

.ifdef SHA1_FAST

.globl sha1
		.type	sha1,@function
		.align	16
sha1:		pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi
		subl	$92,%esp

		leal	8(%esp),%ecx
		leal	sha1start,%edx
		movl	%ecx,(%esp)
		xorl	%ebx,%ebx
sha1loop1:	movl	(%edx,%ebx,4),%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	sha1loop1

		movl	116(%esp),%edi
		movl	112(%esp),%ebp
sha1loop2:	cmpl	$64,%edi
		jnae	sha1loop2end
		movl	%ebp,4(%esp)
		call	sha1block
		addl	$64,%ebp
		subl	$64,%edi
		jmp	sha1loop2

sha1loop2end:	leal	28(%esp),%esi
		movl	%esi,4(%esp)
		xorl	%ebx,%ebx
		testl	%edi,%edi
		je	sha1loop3end

sha1loop3:	movb	(%ebp,%ebx,),%al
		movb	%al,(%esi,%ebx,)
		incl	%ebx
		decl	%edi
		jne	sha1loop3

sha1loop3end:	movb	$128,%al
sha1loop4:	movb	%al,(%esi,%ebx,)
		xorl	%eax,%eax
		incl	%ebx
		cmpl	$56,%ebx
		je	sha1loop4end
		cmpl	$64,%ebx
		jne	sha1loop4
		movl	%eax,%ebx
		call	sha1block
		movl	%ebx,%eax
		jmp	sha1loop4

sha1loop4end:	movl	116(%esp),%edx
		movl	%edx,%ecx
		shrl	$29,%ecx
		bswapl	%ecx
		shll	$3,%edx
		bswapl	%edx
		movl	%ecx,(%esi,%ebx,)
		movl	%edx,4(%esi,%ebx,)
		call	sha1block

		movl	(%esp),%edx
		movl	120(%esp),%ecx
		xorl	%ebx,%ebx
sha1loop5:	movl	(%edx,%ebx,4),%eax
		bswapl	%eax
		movl	%eax,(%ecx,%ebx,4)
		incl	%ebx
		cmpl	$5,%ebx
		jne	sha1loop5

.ifdef SHA1_PARANOID

		movl	$16,%ebx
		xorl	%eax,%eax
sha1loop6:	movl	%eax,(%esi)
		addl	$4,%esi
		decl	%ebx
		jne	sha1loop6

.endif

		addl	$92,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void sha1hmkey(WORD08 *key,WORD32 keylength,SHA1HMDATA *ptr) */

.ifdef	_SHA1_HMAC

.globl sha1hmkey
		.type	sha1hmkey,@function
		.align	16
sha1hmkey:	pushl	%ebx
		pushl	%ebp
		pushl	%esi
		pushl	%edi

		movl	20(%esp),%ebp
		movl	24(%esp),%esi
		movl	28(%esp),%edi

		subl	$124,%esp

		cmpl	$65,%esi
		jnae	sha1hmkey1
		leal	12(%esp),%ebx
		movl	%ebx,(%esp)
		call	sha1init
		movl	%ebp,(%esp)
		movl	%esi,4(%esp)
		movl	%ebx,8(%esp)
		call	sha1next
		leal	104(%esp),%ebp
		movl	%ebp,(%esp)
		movl	%ebx,4(%esp)
		call	sha1end
		movl	$20,%esi
		xorl	%eax,%eax
		movl	$5,%edx
sha1hmkeyloop1:	movl	%eax,(%ebx)
		addl	$4,%ebx
		decl	%edx
		jne	sha1hmkeyloop1

sha1hmkey1:	xorl	%ecx,%ecx
		leal	sha1start,%edx
sha1hmkeyloop2:	movl	(%edx,%ecx,4),%eax
		movl	%eax,(%edi,%ecx,4)
		movl	%eax,20(%edi,%ecx,4)
		incl	%ecx
		cmpl	$5,%ecx
		jne	sha1hmkeyloop2

		leal	12(%esp),%ebx
		movl	%ebx,4(%esp)

		xorl	%ecx,%ecx
		movb	$54,%dl
		jmp	sha1hmkey2
sha1hmkeyloop3:	movb	(%ebp,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%ebx,%ecx,)
		incl	%ecx
sha1hmkey2:	cmpl	%ecx,%esi
		jne	sha1hmkeyloop3

		jmp	sha1hmkey3
sha1hmkeyloop4:	movb	%dl,(%ebx,%ecx,)
		incl	%ecx
sha1hmkey3:	cmpl	$64,%ecx
		jne	sha1hmkeyloop4

		movl	%edi,(%esp)
		call	sha1block

		xorl	%ecx,%ecx
		movb	$92,%dl
		jmp	sha1hmkey4
sha1hmkeyloop5:	movb	(%ebp,%ecx,),%al
		xorb	%dl,%al
		movb	%al,(%ebx,%ecx,)
		incl	%ecx
sha1hmkey4:	cmpl	%ecx,%esi
		jne	sha1hmkeyloop5

		jmp	sha1hmkey5
sha1hmkeyloop6:	movb	%dl,(%ebx,%ecx,)
		incl	%ecx
sha1hmkey5:	cmpl	$64,%ecx
		jne	sha1hmkeyloop6

		addl	$20,(%esp)
		call	sha1block

		leal	12(%esp),%ebx
		leal	104(%esp),%ecx
		xorl	%edx,%edx
		xorl	%eax,%eax
sha1hmkeyloop7:	movl	%eax,(%ebx,%edx,4)
		movb	%al,(%ecx,%edx,)
		incl	%edx
		cmpl	$20,%edx
		jne	sha1hmkeyloop7

		addl	$124,%esp
		popl	%edi
		popl	%esi
		popl	%ebp
		popl	%ebx
		ret

.endif

/* void sha1hminit(SHA1DATA *ptr,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FULL

.globl sha1hminit
		.type	sha1hminit,@function
		.align	16
sha1hminit:	xorl	%edx,%edx
		pushl	%ebx
		movl	8(%esp),%ebx
		movl	12(%esp),%ecx
		movb	%dl,88(%ebx)
sha1hminitloop:	movl	(%ecx,%edx,4),%eax
		movl	%eax,(%ebx,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	sha1hminitloop
		movl	$64,%edx
		movl	%edx,20(%ebx)
		popl	%ebx
		ret

.endif

/* void sha1hmend(WORD08 *result,SHA1DATA *ptr,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FULL

.globl sha1hmend
		.type	sha1hmend,@function
		.align	16
sha1hmend:	pushl	%ebx
		pushl	%esi
		subl	$12,%esp
		movl	%esp,%esi
		movl	24(%esi),%eax
		movl	%eax,(%esi)
		movl	28(%esi),%ebx
		movl	%ebx,4(%esi)
		call	sha1end
		movl	32(%esi),%ecx
		xorl	%edx,%edx
		movb	%dl,88(%ebx)
sha1hmendloop:	movl	20(%ecx,%edx,4),%eax
		movl	%eax,(%ebx,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	sha1hmendloop
		movl	$64,%edx
		movl	%edx,20(%ebx)
		movl	$20,%edx
		movl	%edx,4(%esi)
		movl	%ebx,8(%esi)
		call	sha1next
		movl	%ebx,4(%esi)
		call	sha1end
		addl	$12,%esp
		popl	%esi
		popl	%ebx
		ret

.endif

/* void sha1hmac(WORD08 *data,WORD32 length,WORD08 *result,SHA1HMDATA *key) */

.ifdef	SHA1_HMAC_FAST

.globl sha1hmac
		.type	sha1hmac,@function
		.align	16
sha1hmac:	xorl	%edx,%edx
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		movl	28(%esp),%ebx
		subl	$104,%esp
		movl	%esp,%esi
		leal	12(%esi),%edi
		movb	%dl,88(%edi)

sha1hmacloop1:	movl	(%ebx,%edx,4),%eax
		movl	%eax,(%edi,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	sha1hmacloop1
		movl	$64,%edx
		movl	%edx,20(%edi)

		movl	120(%esi),%eax
		movl	%eax,(%esi)
		movl	124(%esi),%eax
		movl	%eax,4(%esi)
		movl	%edi,8(%esi)
		call	sha1next

		movl	128(%esi),%eax
		movl	%eax,(%esi)
		movl	%edi,4(%esi)
		call	sha1end

		xorl	%edx,%edx
		movb	%dl,88(%edi)
sha1hmacloop2:	movl	20(%ebx,%edx,4),%eax
		movl	%eax,(%edi,%edx,4)
		incl	%edx
		cmpl	$5,%edx
		jne	sha1hmacloop2
		movl	$64,%edx
		movl	%edx,20(%edi)

		movl	$20,%edx
		movl	%edx,4(%esi)
		call	sha1next

		movl	%edi,4(%esi)
		call	sha1end

		addl	$104,%esp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

.endif

.data

		.align	16
sha1start:	.long	0x67452301,0xefcdab89,0x98badcfe
		.long	0x10325476,0xc3d2e1f0

