/*                                                                            */
/* virtual private network daemon (vpnd)                                      */
/*                                                                            */
/* cryptographic stuff (c) 1999, 2005 Andreas Steinmetz, ast@domdv.de         */
/* other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz*/
/*                                                                            */
/* License:                                                                   */
/* This code is in the public domain (*) under the GNU public license.        */
/* The copyright holders will however retain their copyright.                 */
/* There is no guarantee for the fitness and usability of this code           */
/* for any purpose. The author and the copyright holders take no              */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/* (*) 'public domain' is used here in the sense of the Wassenaar treaty.     */
/*                                                                            */

.include	"offsets.s"
 
.text

/* void checksum(WORD08 *data,WORD32 length,WORD08 *out) */

.globl checksum
		.type	checksum,@function
		.align	16
checksum:
		xorw	%cx,%cx
		testl	%esi,%esi
		jz	wsum
chkloop:	movzbw	(%rdi),%ax
		rolw	$1,%cx
		incq	%rdi
		xorw	%ax,%cx
		decl	%esi
		jnz	chkloop
wsum:		movw	%cx,(%rdx)

/* void nocrypt(WORD08 *data,WORD32 *schedule) */

.globl nocrypt
		.type	nocrypt,@function

nocrypt:	ret

/* void encrypt_cfb_64_8(WORD08 *data,WORD32 total,VPN *anchor) */

.globl encrypt_cfb_64_8
		.type	encrypt_cfb_64_8,@function
		.align	16
encrypt_cfb_64_8:
		pushq	%rbx
		pushq	%rbp
		pushq	%r12
		pushq	%r13
		movq	%rdx,%r12
		movq	%rdi,%rbp
		movl	%esi,%r13d
		movq	local_iv(%r12),%rax
		movzbq	wwhite(%r12),%rbx
		pushq	%rax
		incq	%rax
		movq	%rax,local_iv(%r12)
enc64loop:	cmpl	$8,%r13d
		jnae	enc64done
		movq	encrypt(%r12),%rax
		movq	local(%r12),%rsi
		movq	%rsp,%rdi
		call	*%rax
		movq	(%rbp),%rax
		xorq	(%rsp),%rax
		movq	%rax,(%rsp)
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		movq	%rax,(%rbp)
		addq	$8,%rbp
		subl	$8,%r13d
		jmp	enc64loop
enc64done:	testl	%r13d,%r13d
		jz	enc8done
enc8loop:	movq	encrypt(%r12),%rax
		movq	local(%r12),%rsi
		movq	%rsp,%rdi
		call	*%rax
		movq	(%rsp),%rax
		xorb	(%rbp),%al
		movb	%al,%cl
		rorq	$8,%rax
		movq	%rax,(%rsp)
		xorb	white(%r12,%rbx,),%cl
		movb	%cl,(%rbp)
		incb	%bl
		incq	%rbp
		decl	%r13d
		jnz	enc8loop
enc8done:	addq	$8,%rsp
		movb	%bl,wwhite(%r12)
		popq	%r13
		popq	%r12
		popq	%rbp
		popq	%rbx
		ret

/* void decrypt_cfb_64_8(WORD08 *data,WORD32 total,VPN *anchor) */

.globl decrypt_cfb_64_8
		.type	decrypt_cfb_64_8,@function
		.align	16
decrypt_cfb_64_8:
		pushq	%rbx
		pushq	%rbp
		pushq	%r12
		pushq	%r13
		movq	%rdx,%r12
		movq	%rdi,%rbp
		movl	%esi,%r13d
		movq	remote_iv(%r12),%rax
		movzbq	rwhite(%r12),%rbx
		pushq	%rax
		incq	%rax
		movq	%rax,remote_iv(%r12)
dec64loop:	cmpl	$8,%r13d
		jnae	dec64done
		movq	encrypt(%r12),%rax
		movq	remote(%r12),%rsi
		movq	%rsp,%rdi
		call	*%rax
		movq	(%rbp),%rax
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		xorb	white(%r12,%rbx,),%al
		rorq	$8,%rax
		incb	%bl
		movq	%rax,%rcx
		xorq	(%rsp),%rax
		movq	%rcx,(%rsp)
		movq	%rax,(%rbp)
		addq	$8,%rbp
		subl	$8,%r13d
		jmp	dec64loop
dec64done:	testl	%r13d,%r13d
		jz	dec8done
dec8loop:	movq	encrypt(%r12),%rax
		movq	remote(%r12),%rsi
		movq	%rsp,%rdi
		call	*%rax
		movq	(%rsp),%rax
		movb	(%rbp),%cl
		xorb	white(%r12,%rbx,),%cl
		incb	%bl
		xorb	%cl,%al
		movb	%al,(%rbp)
		movb	%cl,%al
		rorq	$8,%rax
		movq	%rax,(%rsp)
		incq	%rbp
		decl	%r13d
		jnz	dec8loop
dec8done:	addq	$8,%rsp
		movb	%bl,rwhite(%r12)
		popq	%r13
		popq	%r12
		popq	%rbp
		popq	%rbx
		ret

/* void genwhite(WORD08 *src,VPN *anchor) */

.globl genwhite
		.type	genwhite,@function
		.align	16
genwhite:
		pushq	%rbx
		pushq	%rbp
		subq	$4168,%rsp
		leaq	white(%rsi),%rbp
		movl	$72,%esi
		movq	%rsp,%rdx
		call	blowfish_key_schedule
		xorq	%rax,%rax
initwhite:	movb	%al,(%rbp,%rax,)
		incb	%al
		jnz	initwhite
		xorq	%rbx,%rbx
mkwhite:	leaq	(%rbp,%rbx,),%rdi
		movq	%rsp,%rsi
		call	blowfish_encrypt
		leaq	(%rbp,%rbx,),%rdi
		movq	%rsp,%rsi
		call	blowfish_encrypt
		leaq	(%rbp,%rbx,),%rdi
		movq	%rsp,%rsi
		call	blowfish_encrypt
		leaq	(%rbp,%rbx,),%rdi
		movq	%rsp,%rsi
		call	blowfish_encrypt
		addb	$8,%bl
		jnz	mkwhite
		xorq	%rax,%rax
		xorq	%rbx,%rbx
clrwhite:	movq	%rax,(%rsp,%rbx,8)
		incq	%rbx
		cmpq	$521,%rbx
		jne	clrwhite
		addq	$4168,%rsp
		popq	%rbp
		popq	%rbx
		ret

/* void encrypt_cbc(WORD08 *data,WORD32 len,WORD32 *schedule,WORD08 *iv) */

.globl encrypt_cbc
		.type	encrypt_cbc,@function
		.align	16
encrypt_cbc:
		pushq	%rbx
		pushq	%rbp
		pushq	%r12
		shrl	$3,%esi
		jz	enccbcdone
		movq	%rdi,%rbx
		movl	%esi,%ebp
		movq	%rdx,%r12
enccbcloop:	movq	(%rcx),%rax
		xorq	%rax,(%rbx)
		movq	%rbx,%rdi
		movq	%r12,%rsi
		call	blowfish_encrypt
		movq	%rbx,%rcx
		addq	$8,%rbx
		decl	%ebp
		jnz	enccbcloop
enccbcdone:	popq	%r12
		popq	%rbp
		popq	%rbx
		ret

/* void decrypt_cbc(WORD08 *data,WORD32 len,WORD32 *schedule,WORD08 *iv) */

.globl decrypt_cbc
		.type	decrypt_cbc,@function
		.align	16
decrypt_cbc:
		pushq	%rbx
		pushq	%rbp
		pushq	%r12
		pushq	%r13
		pushq	%r14
		shrl	$3,%esi
		jz	deccbcdone
		movq	%rdi,%rbx
		movl	%esi,%ebp
		movq	%rdx,%r14
		movq	(%rcx),%r12
deccbcloop:	movq	(%rbx),%r13
		movq	%rbx,%rdi
		movq	%r14,%rsi
		call	blowfish_decrypt
		xorq	%r12,(%ebx)
		movq	%r13,%r12
		addq	$8,%rbx
		decl	%ebp
		jnz	deccbcloop
deccbcdone:	popq	%r14
		popq	%r13
		popq	%r12
		popq	%rbp
		popq	%rbx
		ret
