/*                                                                            */
/* virtual private network daemon (vpnd)                                      */
/*                                                                            */
/* cryptographic stuff (c) 1999 Andreas Steinmetz, ast@domdv.de               */
/* other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz*/
/*                                                                            */
/* License:                                                                   */
/* This code is in the public domain (*) under the GNU public license.        */
/* The copyright holders will however retain their copyright.                 */
/* There is no guarantee for the fitness and usability of this code           */
/* for any purpose. The author and the copyright holders take no              */
/* responsibility for any damages caused by the use of this code.             */
/* Distribution and use of this code is explicitly granted provided           */
/* that the above header is not modified and the above conditions             */
/* are met.                                                                   */
/* (*) 'public domain' is used here in the sense of the Wassenaar treaty.     */
/*                                                                            */

.include	"offsets.s"
 
.text

/* void checksum(WORD08 *data,WORD32 length,WORD08 *out) */

.globl checksum
		.type	checksum,@function
		.align	16
checksum:
		pushl	%ebx
		movl	12(%esp),%ecx
		movl	8(%esp),%edx
		xorl	%eax,%eax
		xorl	%ebx,%ebx
		testl	%ecx,%ecx
		jz	wsum
chkloop:	movzbw	(%edx),%bx
		rolw	$1,%ax
		incl	%edx
		xorw	%bx,%ax
		decl	%ecx
		jnz	chkloop
wsum:		movl	16(%esp),%edx
		popl	%ebx
		movw	%ax,(%edx)

/* void nocrypt(WORD08 *data,WORD32 *schedule) */

.globl nocrypt
		.type	nocrypt,@function

nocrypt:	ret

/* void encrypt_cfb_64_8(WORD08 *data,WORD32 total,VPN *anchor) */

.globl encrypt_cfb_64_8
		.type	encrypt_cfb_64_8,@function
		.align	16
encrypt_cfb_64_8:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		pushl	%ebp
		subl	$16,%esp

		/* copy iv to buffer */

		movl	44(%esp),%esi
		leal	local_iv(%esi),%edx
		movl	(%edx),%eax
		movl	4(%edx),%ebx
		movl	%eax,8(%esp)
		movl	%ebx,12(%esp)

		/* increase iv */

		incl	%eax
		movl	%eax,(%edx)
		jnz	noencivh
		incl	%ebx
		movl	%ebx,4(%edx)

		/* get data, total, wwhite and globals buffer address */

noencivh:	movl	36(%esp),%edi
		movl	40(%esp),%ebp
		xorl	%ebx,%ebx
		movb	wwhite(%esi),%bl
		movl	local(%esi),%ecx

		/* set up parameters for encrypt calls */

		leal	8(%esp),%eax
		movl	%eax,(%esp)
		movl	%ecx,4(%esp)

		/* for all large blocks use CFB64 */

enc64loop:	cmpl	$8,%ebp
		jnae	enc64done
		movl	encrypt(%esi),%eax
		call	*%eax
		xorl	%edx,%edx
enc64dta:	movb	(%edi),%al
		xorb	8(%esp,%edx,),%al
		movb	%al,8(%esp,%edx,)
		xorb	white(%esi,%ebx,),%al
		movb	%al,(%edi)
		incl	%edx
		incl	%edi
		incb	%bl
		cmpl	$8,%edx
		jne	enc64dta
		subl	$8,%ebp
		jmp	enc64loop

		/* for all remaining data bytes use CFB8 */

enc64done:	testl	%ebp,%ebp
		jz	enc8done
enc8loop:	movl	encrypt(%esi),%eax
		call	*%eax
		movb	(%edi),%al
		xorb	8(%esp),%al
		movl	9(%esp),%edx
		movl	13(%esp),%ecx
		movl	%edx,8(%esp)
		movl	%ecx,12(%esp)
		movb	%al,15(%esp)
		xorb	white(%esi,%ebx,),%al
		movb	%al,(%edi)
		incb	%bl
		incl	%edi
		decl	%ebp
		jnz	enc8loop

		/* save new wwhite value */

enc8done:	addl	$16,%esp
		movb	%bl,wwhite(%esi)

		popl	%ebp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

/* void decrypt_cfb_64_8(WORD08 *data,WORD32 total,VPN *anchor) */

.globl decrypt_cfb_64_8
		.type	decrypt_cfb_64_8,@function
		.align	16
decrypt_cfb_64_8:
		pushl	%ebx
		pushl	%edi
		pushl	%esi
		pushl	%ebp
		subl	$16,%esp

		/* copy iv to buffer */

		movl	44(%esp),%esi
		leal	remote_iv(%esi),%edx
		movl	(%edx),%eax
		movl	4(%edx),%ebx
		movl	%eax,8(%esp)
		movl	%ebx,12(%esp)

		/* increase iv */

		incl	%eax
		movl	%eax,(%edx)
		jnz	nodecivh
		incl	%ebx
		movl	%ebx,4(%edx)

		/* get data, total, rwhite and globals buffer address */

nodecivh:	movl	36(%esp),%edi
		movl	40(%esp),%ebp
		xorl	%ebx,%ebx
		movb	rwhite(%esi),%bl
		movl	remote(%esi),%ecx

		/* set up parameters for encrypt calls */

		leal	8(%esp),%eax
		movl	%eax,(%esp)
		movl	%ecx,4(%esp)

		/* for all large blocks use CFB64 */

dec64loop:	cmpl	$8,%ebp
		jnae	dec64done
		movl	encrypt(%esi),%eax
		call	*%eax
		xorl	%edx,%edx
dec64dta:	movb	(%edi),%al
		xorb	white(%esi,%ebx,),%al
		movb	%al,%cl
		xorb	8(%esp,%edx,),%al
		movb	%cl,8(%esp,%edx,)
		movb	%al,(%edi)
		incl	%edx
		incl	%edi
		incb	%bl
		cmpl	$8,%edx
		jne	dec64dta
		subl	$8,%ebp
		jmp	dec64loop

		/* for all remaining data bytes use CFB8 */

dec64done:	testl	%ebp,%ebp
		jz	dec8done
dec8loop:	movl	encrypt(%esi),%eax
		call	*%eax
		movb	(%edi),%al
		xorb	white(%esi,%ebx,),%al
		movb	%al,%cl
		xorb	8(%esp),%al
		movl	9(%esp),%edx
		movb	%al,(%edi)
		movl	13(%esp),%eax
		movl	%edx,8(%esp)
		movl	%eax,12(%esp)
		movb	%cl,15(%esp)
		incb	%bl
		incl	%edi
		decl	%ebp
		jnz	dec8loop

		/* save new rwhite value */

dec8done:	addl	$16,%esp
		movb	%bl,rwhite(%esi)

		popl	%ebp
		popl	%esi
		popl	%edi
		popl	%ebx
		ret

/* void genwhite(WORD08 *src,VPN *anchor) */

.globl genwhite
		.type	genwhite,@function
		.align	16
genwhite:
		pushl	%ebx
		pushl	%esi
		movl	12(%esp),%eax
		movl	16(%esp),%esi
		subl	$4180,%esp
		movl	%eax,(%esp)
		movl	$72,4(%esp)
		leal	12(%esp),%eax
		movl	%eax,8(%esp)
		call	blowfish_key_schedule
		leal	white(%esi),%esi
		xorl	%ebx,%ebx
initwhite:	movb	%bl,(%esi,%ebx,)
		incb	%bl
		jnz	initwhite
		leal	12(%esp),%eax
		movl	%eax,4(%esp)
mkwhite:	movl	%esi,(%esp)
		call	blowfish_encrypt
		call	blowfish_encrypt
		call	blowfish_encrypt
		call	blowfish_encrypt
		addl	$8,%esi
		addb	$8,%bl
		jnz	mkwhite
		xorl	%eax,%eax
clrwhite:	movl	%eax,12(%esp,%ebx,4)
		incl	%ebx
		cmpl	$1042,%ebx
		jne	clrwhite
		addl	$4180,%esp
		popl	%esi
		popl	%ebx
		ret

/* void encrypt_cbc(WORD08 *data,WORD32 len,WORD32 *schedule,WORD08 *iv) */

.globl encrypt_cbc
		.type	encrypt_cbc,@function
		.align	16
encrypt_cbc:
		pushl	%ebx
		pushl	%esi
		movl	12(%esp),%esi
		movl	16(%esp),%ebx
		movl	20(%esp),%ecx
		movl	24(%esp),%eax
		subl	$8,%esp
		movl	%ecx,4(%esp)
		shrl	$3,%ebx
		jz	enccbcdone
enccbcloop:	movl	(%esi),%ecx
		movl	4(%esi),%edx
		xorl	(%eax),%ecx
		xorl	4(%eax),%edx
		movl	%ecx,(%esi)
		movl	%edx,4(%esi)
		movl	%esi,(%esp)
		call	blowfish_encrypt
		movl	%esi,%eax
		addl	$8,%esi
		decl	%ebx
		jnz	enccbcloop
enccbcdone:	addl	$8,%esp
		popl	%esi
		popl	%ebx
		ret

/* void decrypt_cbc(WORD08 *data,WORD32 len,WORD32 *schedule,WORD08 *iv) */

.globl decrypt_cbc
		.type	decrypt_cbc,@function
		.align	16
decrypt_cbc:
		pushl	%ebx
		pushl	%esi
		movl	12(%esp),%esi
		movl	16(%esp),%ebx
		movl	20(%esp),%ecx
		movl	24(%esp),%eax
		subl	$24,%esp
		movl	%ecx,4(%esp)
		movl	(%eax),%ecx
		movl	4(%eax),%edx
		movl	%ecx,8(%esp)
		movl	%edx,12(%esp)
		shrl	$3,%ebx
		jz	deccbcdone
deccbcloop:	movl	8(%esp),%eax
		movl	12(%esp),%ecx
		movl	%eax,16(%esp)
		movl	%ecx,20(%esp)
		movl	(%esi),%eax
		movl	4(%esi),%ecx
		movl	%eax,8(%esp)
		movl	%ecx,12(%esp)
		movl	%esi,(%esp)
		call	blowfish_decrypt
		movl	(%esi),%eax
		movl	4(%esi),%ecx
		xorl	16(%esp),%eax
		xorl	20(%esp),%ecx
		movl	%eax,(%esi)
		movl	%ecx,4(%esi)
		addl	$8,%esi
		decl	%ebx
		jnz	deccbcloop
deccbcdone:	addl	$24,%esp
		popl	%esi
		popl	%ebx
		ret
