/*
 * virtual private network daemon (vpnd)
 *
 * cryptographic stuff (c) 1999 Andreas Steinmetz, ast@domdv.de
 * other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz
 * (c) 2001,2005 Andreas Steinmetz
 *
 * License:
 * This code is in the public domain (*) under the GNU public license.
 * The copyright holders will however retain their copyright.
 * There is no guarantee for the fitness and usability of this code
 * for any purpose. The author and the copyright holders take no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 */

/* header files */

#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/tcp.h>
#ifdef SunOS
#include <sys/stream.h>
#include <sys/stropts.h>
#include <sys/sockio.h>
#include <sys/dlpi.h>
#endif
#if defined(FreeBSD) || defined(OSNetBSD) || defined(OSOpenBSD) || defined(SunOS)
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#endif
#include <netinet/ip_icmp.h>
#include <net/if.h>
#ifdef LINUX1
#include <net/if_route.h>
#include <linux/if_slip.h>
#endif
#ifdef LINUX2
#include <net/route.h>
#ifdef LINSLIP
#include <linux/if_slip.h>
#else
#include <net/if_slip.h>
#endif
#include <net/ppp_defs.h>
#include <linux/if_ppp.h>
#endif
#include <sys/resource.h>
#if defined(FreeBSD) || defined(OSNetBSD) || defined(OSOpenBSD)
#include <net/slip.h>
#if defined(OSOpenBSD) && defined(USE_PPP)
#include <net/ppp_defs.h>
#include <net/if_ppp.h>
#endif
#endif
#ifdef FreeBSD
#include <net/if_var.h>
#endif
#ifdef SunOS
#include <net/route.h>
#include <stropts.h>
#include <sys/tihdr.h>
#include <inet/mib2.h>
#endif
#if defined(FreeBSD) || defined(OSNetBSD) || defined(OSOpenBSD)
#include <machine/param.h>
#include <sys/mbuf.h>
#include <net/slcompress.h>
#if defined(OSOpenBSD) && !defined(USE_PPP)
#include <net/if_slvar.h>
#endif
#include <net/route.h>
#include <sys/sysctl.h>
#include <net/if_dl.h>
#endif
#include <sys/un.h>
#include <netdb.h>
#include <sys/termios.h>
#include <stdlib.h>
#include <signal.h>
#include <syslog.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/wait.h>
#ifdef COMPRESS
#include <zlib.h>
#endif
#include <errno.h>
#ifdef LINUX2
#include <sched.h>
#include <sys/mman.h>
#endif
#include "common.h"
#include "blowfish.h"
#include "md5.h"
#include "sha1.h"
#include "rmd160.h"

/* AF_UNIX pathname buffer size */

#ifndef UNIX_PATH_MAX
#define UNIX_PATH_MAX 108
#endif

/* special, if LOG_PERROR is not defined */

#ifndef LOG_PERROR
#define LOG_PERROR 0
#endif

/* special if _NSIG is not defined */

#ifndef _NSIG
#define _NSIG NSIG
#endif

/* special definitions, do not change!!! */

#define VERSION "1.1.2"	/* current vpnd version number			  */
#define MAXBLOCK 2048	/* largest block size transferred, do not change! */
#define MAXIDLE 900	/* longest link idle time before link test	  */
#define XON 0x11	/* XON (for escaping/filtering)			  */
#define XOFF 0x13	/* XOFF (for escaping/filtering)		  */
#define ESC 0x1b	/* ESCAPE (for escaping/filtering)		  */
#define PING 0		/* out of band linktest request			  */
#define PONG 1		/* out of band linktest reply			  */
#define MAXWAIT 50	/* maximum wait of 5 seconds for linkcheck reply  */
#define MAXIPOPT 15	/* limit for type of service/precedence definition*/
#define ROUTES 9	/* total amount of routing entries possible       */
#define XKEYSIZE 256	/* extended key file size			  */
#define XKEYVER 0	/* extended key file version id			  */
#define TRANSACTID 3	/* transaction id position in extended key file	  */
#define MASTER0 4	/* master secret 0 position in extended key file  */
#define MASTER1 76	/* master secret 1 position in extended key file  */
#define IV0 148		/* remote iv 0 position in extended key file	  */
#define IV1 156		/* remote iv 1 position in extended key file	  */
#define KEYID 164	/* key id position in extended key file		  */

/* system routing table file */

#define ROUTELIST "/proc/net/route"

/* debug definitions */

#ifdef DEBUG
#define DEBUG1(a,b)         {if(debug>a){printf(b);fflush(stdout);}}
#define DEBUG2(a,b,c)       {if(debug>a){printf(b,c);fflush(stdout);}}
#define DEBUG3(a,b,c,d)     {if(debug>a){printf(b,c,d);fflush(stdout);}}
#define DEBUG4(a,b,c,d,e)   {if(debug>a){printf(b,c,d,e);fflush(stdout);}}
#define GOTO(a,b)           {DEBUG2(3,"%s\n",a);goto b;}
#define JUMP(a,b)           {DEBUG3(3,"%s %s\n",a,strerror(errno));goto b;}
#define RET(a,b)            {DEBUG2(3,"%s\n",a);return b;}
#define RETURN(a,b)         {DEBUG3(3,"%s %s\n",a,strerror(errno));return b;}
#define ERRNO(a)            {DEBUG3(3,"%s %s\n",a,strerror(errno));}
#define ENTER(a)            {DEBUG2(2,"%s called\n",a);}
#define LEAVE(a)            {DEBUG2(2,"%s complete\n",a);}
#else
#define DEBUG1(a,b)
#define DEBUG2(a,b,c)
#define DEBUG3(a,b,c,d)
#define DEBUG4(a,b,c,d,e)
#define GOTO(a,b)           goto b
#define JUMP(a,b)           goto b
#define RET(a,b)            return b
#define RETURN(a,b)         return b
#define ERRNO(a)            {}
#define ENTER(a)
#define LEAVE(a)
#endif

/* cipher definitions */

#define NONE 0
#define BLOWFISH 1

/* message ids for syslog messages */

#define SHUTDOWN    1
#define SIGNAL      2
#define SLIPFAIL    3
#define SLIPUP      4
#define SRVSFAIL    5
#define SRVSLSTN    6
#define PEERFAIL    7
#define CRYPTFAIL   8
#define CCONNECT    9
#define DEVFAIL    10
#define FORKFAIL   11
#define INITCHAT   12
#define SELECTFAIL 13
#define CHATFAIL   14
#define DCONNECT   15
#define SPEERFAIL  16
#define ACPTERR    17
#define ILLEGAL    18
#define PEEROPT    19
#define PEERIOCTL  20
#define SCRYPT     21
#define SCONNECT   22
#define KEYFAIL    23
#define FALLBACK   24
#define STARTUP    25
#define DCONTROL   26
#define DSCONTROL  27

/* request ids for control socket */

#define CTRL_STATUS	0		/* request status information	*/
#define CTRL_DOWN	1		/* request disconnect		*/
#define CTRL_FORCEDOWN	2		/* request forced disconnect	*/

/* request answers for control socket */

#define CTRL_FAIL	0		/* request failed		*/
#define	CTRL_OK		1		/* request succeeded		*/
#define CTRL_ISUP	2		/* peer link is up		*/
#define CTRL_ISDOWN	3		/* peer link is down		*/

/* rtp compression, do not change! */

#define RTPMAX		32		/* rtp compression slots	*/
#define RTPNEG		16		/* rtp negative cache slots	*/

/* packetizer states */

#define NONE		0		/* empty packet state		*/
#define IP		1		/* IPv4 packet			*/
#define VJC_COMP	2		/* Van Jacobsen compressed TCP	*/
#define VJC_UNCOMP	3		/* Van Jacobsen uncompressed TCP*/
#define RTP_COMP	4		/* RFC2508 compressed RTP	*/
#define RTP_UNCOMP	5		/* RFC2508 uncompressed RTP	*/
#define STREAM		16		/* converted packet is ready	*/
#define ERR		17		/* packet is in error state	*/

/* ip/udp/rtp header */

typedef struct
{
WORD08 verihl;				/* ip version/header length	*/
WORD08 tos;				/* ip type of service		*/
WORD16 tot_len;				/* ip total datagram length	*/
WORD16 id;				/* ip identification		*/
WORD16 frag_off;			/* ip flags/fragmentation offset*/
WORD08 ttl;				/* ip time to live		*/
WORD08 protocol;			/* ip protocol			*/
WORD16 check;				/* ip header checksum		*/
WORD32 saddr;				/* ip source address		*/
WORD32 daddr;				/* ip destination address	*/
WORD16 source;				/* udp source port		*/
WORD16 dest;				/* udp destination port		*/
WORD16 len;				/* udp datagram length		*/
WORD16 chksum;				/* udp datagram checksum	*/
WORD08 verpxcc;				/* rtp version/p/x/csrc count	*/
WORD08 mpt;				/* rtp marker bit/payload type	*/
WORD16 seq;				/* rtp sequence number		*/
WORD32 timestamp;			/* rtp timestamp		*/
WORD32 ssrc;				/* rtp synchronization source	*/
WORD32 csrc[15];			/* rtp contributing source	*/
} RTP;

/* rtp compression state work area */

typedef struct _rtpstate
{
struct _rtpstate *next;			/* next work area in ring	*/
WORD08 id;				/* work area id			*/
WORD08 seq;				/* compression sequence number	*/
WORD16 ipid;				/* current ip id delta		*/
WORD32 timestamp;			/* current rtp timestamp delta	*/
WORD32 negative;			/* negative cacheing detection	*/
RTP hdr;				/* current ip/udp/rtp header	*/
} RTPSTATE;

/* rtp compression negative state work area */

typedef struct _negstate
{
struct _negstate *next;			/* next work area in ring	*/
WORD32 saddr;				/* IPv4 source address		*/
WORD32 daddr;				/* IPv4 destination address	*/
WORD16 source;				/* udp source port		*/
WORD16 dest;				/* udp destination port		*/
WORD32 skip;				/* amount of packets to skip	*/
} NEGSTATE;

/* conversion to/from packet data structure */

typedef struct
{
int state;				/* current processing state	*/
int length;				/* output data total length	*/
int total;				/* input bytes total amount	*/
int processed;				/* input bytes processed amount	*/
WORD08 *data;				/* pointer to actual output data*/
WORD16 chksum;				/* ppp checksum generation/vry	*/
WORD08 bfr[(2*MAXBLOCK)+9];		/* work buffer (output)		*/
RTPSTATE *rtplast;			/* current compression state	*/
RTPSTATE rtpstate[RTPMAX];		/* rtp compression state array	*/
NEGSTATE *neglast;			/* current negative cache state	*/
NEGSTATE negstate[RTPNEG];		/* negative compression cache	*/
WORD08 hdr[198];			/* compression work buffer	*/
} PKG;

/* configuration file parse result */

typedef struct
{
int found;				/* command found flag		*/
char *p1;				/* first parameter		*/
char *p2;				/* second parameter		*/
char *p3;				/* third parameter		*/
} CFGDATA;

/* vpnd global data, changes affect cryptox86.s, be very careful! */

typedef struct _vpn
{
WORD08 rwhite;				/* read data unwhiten index	*/
WORD08 wwhite;				/* write data whiten index	*/
WORD08 localline;			/* CLOCAL for serial line	*/
WORD08 rtscts;				/* CRTSCTS for serial line	*/
WORD08 cslip;				/* compressed slip headers	*/
WORD08 nocompress;			/* data compression disable	*/
WORD08 peercomp;			/* peer data compression cap.	*/
WORD08 peerroute;			/* peer priority route flag	*/
WORD08 oobfix;				/* link test out of band fix	*/
WORD08 extended;			/* extended master key file mode*/
WORD08 passwd;				/* master secret user key flag	*/
WORD08 mode;				/* client/server mode		*/
WORD08 serialmode;			/* flag for serial or ip mode	*/
WORD08 xfilter;				/* XON/OFF escape and filtering	*/
WORD08 autoroute;			/* ifconfig adds route		*/
WORD08 slip;				/* slip/ppp up flag		*/
WORD08 cipher;				/* cipher to be used		*/
WORD08 unused;				/* unused, spare for future use	*/
WORD08 mac;				/* message auth width 		*/
WORD08 keysize;				/* key length in bytes		*/
WORD16 threshold;			/* compression test threshold	*/
WORD16 retry;				/* global retry delay		*/
WORD16 keepalive;			/* send pings when idle		*/
WORD16 linktest;			/* link test after idle time	*/
WORD16 noresponse;			/* missing pong line drop	*/
WORD16 suspend;				/* tcp link suspend time	*/
WORD16 rxmax;				/* maximum receive wait		*/
WORD16 txmax;				/* maximum transmit wait	*/
WORD16 connwait;			/* maximum TCP connect wait	*/
WORD16 ipopts;				/* type of service/precedence	*/
WORD16 rmax;				/* total of additional routes	*/
WORD16 server_port;			/* server port			*/
WORD16 client_port;			/* client port			*/
WORD16 mtu;				/* maximum transfer unit (slip)	*/
int pty;				/* master side of tty		*/
int keyttl;				/* current key time to live	*/
int peer;				/* handle to peer		*/
int server;				/* server accept handle		*/
int child;				/* init chat child process pid	*/
int ping;				/* icmp socket for pings	*/
int tty;				/* tty used for slip interface	*/
int disc;				/* saved tty line dicipline	*/
int proxy;				/* number of slip device	*/
int serial;				/* serial device file handle	*/
int speed;				/* serial line speed		*/
int sendbuf;				/* socket send buffer size	*/
void (*encrypt)(WORD08 *,WORD32 *);	/* pointer to encryption proc.	*/
WORD32 *local;				/* key schedule local to remote */
WORD32 *remote;				/* key schedule remote to local */
WORD08 local_iv[BLOWFISH_BLOCKSIZE];	/* local iv			*/
WORD08 remote_iv[BLOWFISH_BLOCKSIZE];	/* remote iv			*/
WORD08 white[256];			/* whitening buffer		*/
char *local_ip;				/* local ip of slip interface	*/
char *remote_ip;			/* remote ip of slip interface	*/
char *server_ip;			/* server ip address		*/
char *client_ip;			/* client ip address		*/
WORD08 icmp_out[64];			/* ping send buffer		*/
WORD08 icmp_in[64];			/* ping receive buffer		*/
struct sockaddr_in icmp_target;		/* remote address of slip link	*/
struct sockaddr_in icmp_source;		/* remote address of slip link	*/
WORD32 rtab[ROUTES][3];			/* additional routes		*/
int lock;				/* serial line lock file handle	*/
char *conffile;				/* default configuration file	*/
char *randomdev;			/* random number device file	*/
char *serialdev;			/* serial device to be used	*/
char *modemchat;			/* modem init chat file		*/
mode_t normalmode;			/* saved file mode		*/
struct termios original;		/* original tty state		*/
struct termios line;			/* original serial state	*/
char *keyfile;				/* master key file		*/
char *lkeyfile;				/* local ext. master key file	*/
char *rkeyfile;				/* remote ext. master key file	*/
WORD08 secret[XKEYSIZE];		/* shared secret		*/
int hmacopt;				/* HMAC operation option	*/
int hmacmode;				/* HMAC selection option	*/
union
{
	MD5HMDATA md5;			/* preprocessed HMAC-MD5 key	*/
	SHA1HMDATA sha1;		/* preprocessed HMAC-SHA1 key	*/
	RMD160HMDATA rmd160;		/* preprocessed HMAC-RMD160 key	*/
} hmkey;
void (*macproc)(WORD08 *,WORD32,WORD08 *,void *); /* mac routine	*/
void (*mackey)(WORD08 *,WORD32,void *); /* mac key generation routine	*/
char peerdev[16];			/* peer priority route device	*/
WORD32 peergate;			/* peer priority route gateway	*/
WORD32 peerip;				/* peer ip for priority route	*/
char *linkup;				/* pathname of linkup process	*/
char *linkdown;				/* pathname of linkdown process	*/
char *slipup;				/* pathname of slipup process	*/
char *slipdown;				/* pathname of slipdown process	*/
char *socksip;				/* socks ip			*/
char *socksuser;			/* socks user name		*/
WORD16 socksport;			/* socks port			*/
WORD08 piv[BLOWFISH_BLOCKSIZE];		/* user key iv			*/
union
{
	BLOWFISH_SCHEDULE(sched);	/* key schedule 1		*/
	char bfr[1024];			/* general purpose buffer	*/
} u1;
union
{
	BLOWFISH_SCHEDULE(sched);	/* key schedule 2		*/
	char bfr[1024];			/* general purpose buffer	*/
} u2;
union
{
	BLOWFISH_SCHEDULE(sched);	/* master secret user key	*/
	char bfr[1024];			/* general purpose buffer	*/
} u3;
BLOWFISH_SCHEDULE(xsched);		/* extended mode key schedule	*/
CFGDATA config[64];			/* configuration file data	*/
WORD08 lbfr[MAXBLOCK+2];		/* local input buffer		*/
WORD08 rbfr[MAXBLOCK+2];		/* peer input buffer		*/
fd_set r;				/* read set for select		*/
fd_set w;				/* write set for select		*/
fd_set e;				/* exception set for select	*/
fd_set s;				/* write set for select		*/
fd_set x;				/* exception set for select	*/
int pppfd;				/* ppp setup (control)		*/
int ifd;				/* ppp setup (interface)	*/
#ifdef SunOS
int mux;				/* Solaris ppp setup (data mux)	*/
#endif
int (*ifhandler)(int,struct _vpn  *);	/* interface handler to use	*/
char *iftype;				/* name of interface type	*/
void (*pkt_init)(PKG *p);		/* packet init routine to use	*/
int (*if_to_pkt)(PKG *p,WORD08 *i, int l);/* if to packet routine to use*/
int (*pkt_to_if)(PKG *p,WORD08 *i, int l);/* packet to if routine to use*/
int pktmode;				/* pkg operation mode flag	*/
int smallrtp;				/* minimize rtp packets flag	*/
PKG ifpkt;				/* if to packet work area	*/
PKG pktif;				/* packet to if work area	*/
struct _vpn *next;			/* next set of global data	*/
} VPN;

extern VPN globals;			/* temporary globals home	*/
extern char *pidfile;			/* process id file		*/
extern WORD08 timeout;			/* sigalrm flag for script test	*/
extern WORD08 verbose;			/* verbose mode for script test	*/
extern WORD08 terminate;		/* termination request (signal)	*/
extern WORD08 dns;			/* dns lookup allowed flag	*/
extern WORD32 facility;			/* syslog facility		*/
extern char *control;			/* control socket pathname	*/
extern int ctrl;			/* control socket		*/

#ifdef DEBUG
extern int debug;			/* debug level			*/
#endif

extern void (*mactab[4])(WORD08 *,WORD32,WORD08 *,void *); /* mac procs	*/
extern void (*macinit[4])(WORD08 *,WORD32,void *); /* mac key procs	*/
extern WORD08 maclen[4];		/* message auth length		*/

/* function prototypes for slip.c */

extern int sliphandler(int,VPN *);

/* function prototypes for ppp.c */

extern int ppphandler(int,VPN *);

/* function prototypes for serial.c */

extern int serialhandler(VPN *);

/* function prototypes for rxtx.c */

extern int dosend(WORD08 *,WORD32,VPN *);
extern int dorecv(WORD08 *,WORD32,VPN *);
extern int oobsend(int,VPN *);
extern int oobrecv(VPN *);

/* function prototypes for crypto.c */

extern int getrandom(WORD08 *,WORD32,WORD32,VPN *);
extern void checksum(WORD08 *,WORD32,WORD08 *,void *);
extern void encrypt_cfb_64_8(WORD08 *,WORD32,VPN *);
extern void decrypt_cfb_64_8(WORD08 *,WORD32,VPN *);
extern int datasend(WORD08 *,WORD32,VPN *);
extern int datarecv(WORD08 *,WORD32,VPN *);
extern void encrypt_cbc(WORD08 *,WORD32,WORD32 *,WORD08 *);
extern void decrypt_cbc(WORD08 *,WORD32,WORD32 *,WORD08 *);
extern void genwhite(WORD08 *,VPN *);
extern int readmaster(VPN *);
extern int writemaster(int,VPN *);
extern int genmaster(VPN *);
extern int cryptosetup(VPN *);
extern int chgpasswd(VPN *);

/* function prototypes for external.c */

extern void doexec(char *,char *);

/* function prototypes for tcp.c */

extern WORD32 getaddr(WORD08 *);
extern int tcpsocket(VPN *);
extern int accept_socket(struct sockaddr_in *,VPN *);
extern void disconnect(int,VPN *);

/* function prototypes for syslog.c */

extern void logmsg(int,int,VPN *);

/* function prototypes for die.c */

extern void closehandles(void);
extern void clearmem(void);
extern void die(int,int);

/* function prototypes for signal.c */

extern void sigdie(int);
extern void chatalarm(int);
extern void setsig(int,void (*)(int));
extern void blocksig(int);

/* function prototypes for chatter.c */

extern int chathandler(char,VPN *);
extern int chatter(VPN *);

/* function prototypes for sequencer.c */

extern void sequencer(VPN *);

/* function prototypes for parse.c */

int checkfile(char *,int);
int chkip(char *);
int chksvrcln(char,char *,char *,char *,VPN *);
int parse(VPN *);

/* function prototypes for vpnd.c */

extern void dummy(void);
extern int main(int,char **);

/* function prototypes for route.c */

extern int route(int,WORD32,WORD32,WORD32,WORD08 *);
extern int peerroute(VPN *);

/* function prototypes for icmp.c */

extern int icmphandler(VPN *);
extern int recvicmp(VPN *);
extern void sendicmp(VPN *);

/* function prototypes for globals.c */

extern void initvars(VPN *);

/* function prototypes for control.c */

extern int controlhandler(int);
extern int docontrol(int);

/* function prototypes for packetizer.c */

extern void rtpcomp_init(PKG *dta);
extern void pkg_slip_init(PKG *dta);
extern int slip_to_pkg(PKG *dta,WORD08 *in,int ilen);
extern int pkg_to_slip(PKG *dta,WORD08 *in,int ilen);
extern void pkg_ppp_init(PKG *dta);
extern int ppp_to_pkg(PKG *dta,WORD08 *in,int ilen);
extern int pkg_to_ppp(PKG *dta,WORD08 *in,int ilen);
