%define name vpnd
%define version 1.1.1

Summary: Daemon which allows secure network interconnection across insecure channels.
Name: %{name}
Version: %{version}
Release: 5
Copyright: GPL
URL: http://sunsite.dk/vpnd/
Group: System Environment/Daemons
Source0: http://sunsite.dk/vpnd/archive/%{name}-%{version}.tar.gz
Requires: libz.so.1 >= 1.1.4
BuildRequires: zlib-devel >= 1.1.4
Provides: %{name}
BuildRoot: /var/tmp/%{name}-%{version}-root
Packager: Robert Hardy <rhardy@webcon.net>
ExcludeArch: sparc alpha # Not sure if this is x86 only
ExclusiveOS: linux freebsd netbsd

%description
The virtual private network daemon vpnd is a daemon which connects two
networks on network level either via TCP/IP or a (virtual) leased line
attached to a serial interface. All data transfered between the two networks
are encrypted using the unpatented free Blowfish encryption algorithm.

vpnd is not intended as a replacement of existing secured communications
software like ssh or tunneling facilities of the operating system. It is,
however, intended as a means of securing transparent network interconnection
across potentially insecure channels.

vpnd was developed in Germany and the Web Servers are located in Denmark and
Canada, so no U.S. export restrictions apply. As the code is put in the
'public domain' in the Wassenaar sense, the Wassenaar treaty doesn't apply,
either.

Secure your systems first, then use vpnd!

%package doc
Summary: Documentation about the virtual private network daemon vpnd.
Group: Documentation

%description doc
The vpnd-doc package contains documentation about the virtual private
network daemon vpnd, including release notes, the vpnd FAQ, examples
on how to use vpnd and sample configuration files.

See http://sunsite.dk/vpnd/ for more details.

Install the vpnd-doc package if you need documentation about vpnd.

%prep
%setup -q -n vpnd

%build
configure
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/sbin
install -m755 vpnd $RPM_BUILD_ROOT/usr/sbin
strip $RPM_BUILD_ROOT/usr/sbin/vpnd

# install docs by hand
mkdir -p $RPM_BUILD_ROOT/usr/doc/vpnd-%{version}
cp -ar README SPEED.TXT FAQ.TXT VERSIONS vpnd.conf samples dynamic-ip-client \
 $RPM_BUILD_ROOT/usr/doc/vpnd-%{version}

mkdir -p $RPM_BUILD_ROOT/etc/vpnd
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m755 samples/initscript_dirbased $RPM_BUILD_ROOT/etc/rc.d/init.d/vpnd

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add vpnd
/etc/rc.d/init.d/vpnd start
# If config files are not there the VPND will not start so these 
# doesn't hurt!

%preun
if [ $1 = 0 ]; then
	if [ -f /var/lock/subsys/vpnd ]; then
		/etc/rc.d/init.d/vpnd stop
	fi
	if [ -f /etc/rc.d/init.d/vpnd ]; then
		/sbin/chkconfig --del vpnd
	fi
fi

%files
%defattr(-,root,root)
/usr/sbin/vpnd
%dir                         /etc/vpnd
%config /etc/rc.d/init.d/vpnd

%files doc
%defattr(-,root,root)
/usr/doc/vpnd-%{version}

%changelog
* Mon Feb 21 2000 Robert Hardy <rhardy@webcon.net>
- Updated to fix delays due to vpnd initscript starting before named.
- Updated spec file install and uninstall scripts  

* Wed Feb 16 2000 Robert Hardy <rhardy@webcon.net>
- Updated initscript to use -l arg by default to allow hostname resolution 
  in config files.

* Sun Jan 30 2000 Robert Hardy <rhardy@webcon.net>
- made initial pair of RPMs based on vpnd V1.1.1

