#
# $Id: Application.make,v 1.8 1999/02/19 11:43:31 saw Rel $
#

SRCS = $(wildcard *.c)
OBJS = $(SRCS:.c=.o)

include ../../Rules.make

all: $(PROGS) $(PROGSUID)

include .depend

%.o: %.c
	$(CC) -c -o $(@) $(CFLAGS) $(<)

$(PROGS) $(PROGSUID): $(OBJS)
	$(CC) -o $(@) $(OBJS) $(LIBS) -L../../common/lib -L../lib -l$(TAGDIR) -lsimpleapps

$(PROGS) $(PROGSUID): ../../common/lib/libsimpleapps.a ../lib/lib$(TAGDIR).a

.depend:
	$(CC) -M $(CFLAGS) $(SRCS) >$(@)

../../Rules.make ../../common/lib/libsimpleapps.a ../lib/lib$(TAGDIR).a:
	$(MAKE) -C $(@D) $(@F)

#
# Installation and cleaning stuff
#
install: all
	if [ -n "$(PROGS)" ]; then \
		cp $(PROGS) ../../bin ; \
	fi
	if [ -n "$(PROGSUID)" ]; then \
		install -m 04555 -o root -g bin $(PROGSUID) ../../bin ; \
	fi

remove:
	cd ../../bin ; rm -f $(PROGS) $(PROGSUID)

clean:
	rm -f *.a *.so *.o *~ $(PROGS) $(PROGSUID)

extraclean: remove clean
	rm -f *.out .#* .depend

#
# Making control
#
.PHONY: all install remove clean extraclean
