#ifndef _LCT_GENERIC_H
#define _LCT_GENERIC_H

#include <stdio.h>				  /* FILE */

typedef enum { False=0, True=1 } lct_boolean;

struct magic
{
  int id;
  char* format_name;
  char* magic;
  char* mask;
  size_t length;
};

struct magicset
{
  size_t max_length_hint;
  const struct magic* m;
};

/* special magic_IDs */
#define FF_END		 0	/* array terminator */
#define FF_UNKNOWN	-1	/* magic == mask == NULL - unidentified (used as default) */
#define FF_HINTS	-2	/* magic == max length for magic and mask in following array
				 * mask == ignored */

FILE *findfile_simple(const char *fnam, const char **dirpath, const char **suffixes);

FILE* findfile(const char *fnam, const char **dirpath, const char **suffixes,
	       char *fullname, size_t maxfullength, FILE* minus_meaning,
	       const struct magicset * magics, int* magic_return);

/* low-level wrappers around findfile() */
#define FINDFILE_WRAPPER_HEADER(NAME) \
FILE* find ## NAME(const char *fnam, char *fullname, size_t maxfullength, \
                   FILE* minus_meaning, int* magic_return)

/* template for wrappers around findfont */
#define FINDFILE_WRAPPER(NAME, PATH, SUFFIXES, MAGICS) \
FINDFILE_WRAPPER_HEADER(NAME) \
{ \
  return findfile(fnam, PATH, SUFFIXES, fullname, maxfullength, minus_meaning, MAGICS, magic_return); \
}

/* from x*.c */
int xfseek (FILE *stream, long offset, int whence);
FILE *xfopen (const char *path, const char *mode, FILE* minus_meaning);

void* xmalloc(size_t n);
char* xstrdup(char *p);

#endif /* _LCT_GENERIC_H */
