#ifndef _LCT_LOCAL_H
#define _LCT_LOCAL_H

#define _GNU_SOURCE

#include <config.h>

#include <locale.h>


#ifdef HAVE_LOCALE_H
# include <libintl.h>
# define _(String) gettext (String)
# ifdef gettext_noop
#  define N_(String) gettext_noop (String)
# else
#  define N_(String) (String)
# endif
#else
/* rough approximation of the functions */
# define _(String) (String)
# define N_(String) (String)
# define textdomain(Domain)
# define bindtextdomain(Package, Directory)
#endif


char* _lct_i18n_number(unsigned n, /* the number of items */
		       char* *buf, unsigned *bufsize, /* output buffer */
		       /* l10n'd strings: */
		       char* zero,		  /* "no bug" */
		       char* singular,		  /* "1 bug" */
		       char* dual,		  /* "2 bugs" */
		       char* plural_to_five,	  /* "%c bugs" */
		       char* more_than_five);	  /* "%u bugs" */

#define LCT_NUMBER(BUF,BUFZIZE,n,sing,plur) \
_lct_i18n_number (n, &BUF, &BUFZIZE,    \
		  _("no " sing),        \
		  _("1 " sing),         \
		  _("2 " plur),         \
		  _("%c " plur),        \
		  _("%u " plur))

#define INITIAL_FONTSLOTS 4
#define INITIAL_CHARSLOTS 256			  /* assumed to be >= 256 */


#endif /* _LCT_LOCAL_H */
