#include <lct/local.h>

#include <lct/font.h>
#include <lct/generic.h>

static const char *fontdirpath[] = { "", DATADIR "/" FONTDIR "/", 
#ifdef LOCALDATADIR
  LOCALDATADIR "/" FONTDIR "/", 
#endif
  0 };
static const char *fontsuffixes[] = { 
  "", ".psf", ".cp", ".bdf", ".fnt", ".psfu", 
  0 };


static const struct magic __ff_magics__[] =
{
    { FFF_PSF,	"PSF",	"\066\004",	"\377\377", 2 },
    { FFF_XPSF,	"XPSF",	"\066\005",	"\377\377", 2 },
    { FFF_CP,	"CP",	"\000\000\000\000\000\000\001\000EGA     ",
      "\000\000\000\000\000\000\377\377\377\377\377\377\377\377\377\377", 16 },
    { FFF_CP,	"CP",	"\000\000\000\000\000\000\001\000VIDEO   ",
      "\000\000\000\000\000\000\377\377\377\377\377\377\377\377\377\377", 16 },
    { FFF_BDF,	"BDF",	"STARTFONT ",	"\377\377\377\377\377\377\377\377\377\377", 10 },
  
  /* default when no magic: */
    { FFF_RAW,	"raw",	NULL, NULL, 0 },
  
  /* terminator */
    { FF_END, NULL, NULL, 0 }
};

/* font-file magics */
const struct magicset ff_magics =
{
  32,				       /* max magic length: more than enough */
  __ff_magics__
};


/* wrappers */

FINDFILE_WRAPPER(font,		fontdirpath,	fontsuffixes,		&ff_magics)
