#include <lct/local.h>

#include <string.h>

#include <lct/font.h>


lct_boolean fff_is_simple_font (int id)
{
  if ((id == FFF_RAW) ||
      (id == FFF_PSF) ||
      (id == FFF_BDF))
    return True;
  else
    return False;
}

lct_boolean fff_is_font_group (int id)
{
  if ((id == FFF_CP) ||
      (id == FFF_XPSF))
    return True;
  else
    return False;
}

char* fff_id_to_name (int id)
{
  int i;
  for (i=0; ff_magics.m[i].id != FF_END; i++)
    if (ff_magics.m[i].id == id)
      return (ff_magics.m[i].format_name);
  
  /* default */
  return _("unknown");
}

int fff_name_to_id (char* name)
{
  int i;
  for (i=0; ff_magics.m[i].id != FF_END; i++)
    if (strcasecmp (ff_magics.m[i].format_name, name) == 0)
      return (ff_magics.m[i].id);
  
  /* default */
  return FF_UNKNOWN;
}

void fff_fprintf_names (FILE* file, char* format)
{
  int i;
  for (i=0; ff_magics.m[i].id != FF_END; i++)
    fprintf (file, format, ff_magics.m[i].format_name);
}
