#include <stdlib.h>
#include <stdio.h>

#define adjust_buf(STRING)                         \
      slen = strlen(STRING);                       \
      if (*bufsize < slen)                         \
	{                                          \
	  *bufsize = slen;                         \
	  *buf = (char*)realloc (*buf, *bufsize);  \
	}

/* stolen from mke2fs.c */
static int log10(unsigned int arg)
{
	int	l;

	for (l=0; arg ; l++)
		arg = arg / 10;
	return l;
}


char* _lct_i18n_number(unsigned n, /* the number of items */
		       char* *buf, unsigned *bufsize, /* output buffer */
		       /* l10n'd strings: */
		       char* zero,		  /* "no bug" */
		       char* singular,		  /* "1 bug" */
		       char* dual,		  /* "2 bugs" */
		       char* plural_to_five,	  /* "%c bugs" */
		       char* more_than_five)	  /* "%u bugs" */
{
  unsigned slen;
  
  switch (n)
    {
    case 0:
      adjust_buf (zero);
      strcpy (*buf, zero);
      break;
      
    case 1:
      adjust_buf (singular);
      strcpy (*buf, singular);
      break;
      
    case 2:
      adjust_buf (dual);
      strcpy (*buf, dual);
      break;
      
    case 3:
    case 4:
    case 5:
      adjust_buf (plural_to_five);
      snprintf(*buf, *bufsize, plural_to_five, "345"[n-3]);
      break;
      
    default:
      slen = strlen(more_than_five) + log10(n);
      if (*bufsize < slen)
	{
	  *bufsize = slen;
	  *buf = (char*)realloc (*buf, *bufsize);
	}
      snprintf(*buf, *bufsize, more_than_five, n);
    }

  return *buf;
}
