#include <lct/local.h>

#include <lct/font.h>
#include <lct/console.h>			  /* KERNDIR */
#include <lct/generic.h>

static const char *mapdirpath[] = { 
  "", 
  DATADIR "/" TRANSDIR "/", 
  CHARMAPDIR "/",
#ifdef LOCALDATADIR
  LOCALDATADIR "/" TRANSDIR "/",
#endif
  0 };
static const char *mapsuffixes[] = {
  "", ".acm",
  0 };
static const char *sfmsuffixes[] = {
  "", ".sfm", ".uni",
  0 };
static const char *sfmfallbacksuffixes[] = {
  "", ".fallback",
  0 };


static const char *keymapdirpath[] =
{
  "", DATADIR "/" KEYMAPDIR "/**/", 
#ifdef LOCALDATADIR
  LOCALDATADIR "/" KEYMAPDIR "/**/",
#endif
  KERNDIR "/", 
  0 };
static const char *keymapsuffixes[] = { 
  "", ".kmap", ".map",
  0 };

static const char *videomodedirpath[] = { "", DATADIR "/" VIDEOMODEDIR "/", 
#ifdef LOCALDATADIR
  LOCALDATADIR "/" VIDEOMODEDIR "/", 
#endif
  0};
static const char *videomodesuffixes[] = { "", 0 };


/* wrappers */

FINDFILE_WRAPPER(acm,		mapdirpath,	mapsuffixes,		NULL)
FINDFILE_WRAPPER(sfm,		mapdirpath,	sfmsuffixes,		NULL)
FINDFILE_WRAPPER(sfmfallback,	mapdirpath,	sfmfallbacksuffixes,	NULL)
FINDFILE_WRAPPER(keymap,	keymapdirpath,	keymapsuffixes,		NULL)
FINDFILE_WRAPPER(videomode,   videomodedirpath, videomodesuffixes,	NULL)
