/*
 * Copyright (c) 2000 Todd C. Miller <Todd.Miller@courtesan.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: extern.h,v 1.1 2000/02/07 01:56:34 millert Exp $
 */

#ifndef _MKTEMP_EXTERN_H
#define _MKTEMP_EXTERN_H

/* Deal with ANSI stuff reasonably.  */
#undef  __P
#if defined (__cplusplus) || defined (__STDC__)
# define __P(args)		args
#else
# define __P(args)		()
#endif

extern int errno;

#ifndef STDC_HEADERS
# if !defined(__GNUC__) && !defined(HAVE_MALLOC_H)
extern void *malloc	__P((size_t));
# endif /* !__GNUC__ && !HAVE_MALLOC_H */ 
#endif /* !STDC_HEADERS */ 

extern char *MKDTEMP __P((char *));
extern int MKSTEMP __P((char *));
extern long get_random __P((void));

#endif /* _MKTEMP_EXTERN_H */
