/*
 * (c) Copyright 1992 by Panagiotis Tsirigotis
 * (c) Sections Copyright 1998-2001 by Rob Braun
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

#ifndef CONF_H
#define CONF_H

/*
 * $Id: conf.h,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $
 */

#include "pset.h"
#include "sconf.h"

struct configuration
{
   pset_h cnf_service_confs ;
   struct service_config *cnf_defaults ;
} ;

#define CNF_DEFAULTS( confp )        (confp)->cnf_defaults
#define CNF_SERVICE_CONFS( confp )   (confp)->cnf_service_confs

status_e                 cnf_get(struct configuration *, time_t) ;
status_e                 cnf_init(struct configuration *, int *, psi_h *) ;
void                     cnf_free(struct configuration *) ;
void                     cnf_dump(struct configuration *, int) ;
struct service_config   *cnf_extract(struct configuration *, struct service_config *) ;
unsigned                 cnf_start_services(struct configuration *) ;

#endif    /* CONF_H */

