/*
 * (c) Copyright 1992 by Panagiotis Tsirigotis
 * (c) Sections Copyright 1998-2001 by Rob Braun
 * All rights reserved.  The file named COPYRIGHT specifies the terms 
 * and conditions for redistribution.
 */

static char RCSid[] = "$Id: util.c,v 1.1.1.1 1999/10/12 17:28:59 bbraun Exp $" ;

#include "config.h"
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#if defined (HAVE_SYS_SOCKET_H)
#include <sys/socket.h>
#endif
/*
 * The following ifdef is for TIOCNOTTY
 */
#ifndef NO_TERMIOS
#ifdef HAVE_SYS_TERMIOS_H
#include <sys/termios.h>
#endif
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif
#else
#include <sys/ioctl.h>
#endif
#include <fcntl.h>

#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif

#include <memory.h>
#include <syslog.h>
#include <errno.h>

#include "pset.h"
#include "sio.h"

#include "defs.h"
#include "xconfig.h"
#include "log.h"
#include "str.h"

void out_of_memory( char *func )
{
   msg( LOG_CRIT, func, ES_NOMEM ) ;
}


struct name_value *nv_find_value( struct name_value nv_array[], char *name )
{
   struct name_value *nvp ;

   for ( nvp = nv_array ; nvp->name ; nvp++ )
   {
      if ( EQ( name, nvp->name ) )
         return( nvp ) ;
   }
   return( NULL ) ;
}


struct name_value *nv_find_name( struct name_value nv_array[], int value )
{
   struct name_value *nvp ;

   for ( nvp = nv_array ; nvp->name ; nvp++ )
   {
      if ( value == nvp->value )
         return( nvp ) ;
   }
   return( NULL ) ;
}


/*
 * A name-value list is exactly what its name says.
 * The functions nv_get_name() and nv_get_value() return a pointer to
 * the entry with the specified value or name respectively.
 *
 * The list ends when an antry with a NULL name is encountered.
 * The value field of that entry is treated in a special manner: if it
 * is non-zero, it is assumed that there exists one more entry whose
 * name field will be returned by the nv_get_name function if it can't
 * find an entry whose value field is equal to its 2nd parameter.
 * If the value field of the NULL entry is 0, then nv_get_name() will
 * return NULL.
 */
 char *nv_get_name( struct name_value nv_array[], int value )
{
   struct name_value *nvp ;

   for ( nvp = nv_array ; nvp->name ; nvp++ )
   {
      if ( value == nvp->value )
         return( nvp->name ) ;
   }
   return( nvp->value ? (nvp+1)->name : NULL ) ;
}



char **argv_alloc( unsigned count )
{
   unsigned argv_size = (count + 1) * sizeof( char *) ;
   char **argv ;
   char *func = "new_argv" ;

   argv = (char **) malloc( argv_size ) ;
   if ( argv == NULL )
   {
      out_of_memory( func ) ;
      return( NULL ) ;
   }
   (void) memset( (char *)argv, 0, (int) argv_size ) ;
   return( argv ) ;
}


/*
 * If size is 0, the pset holds strings
 */
status_e copy_pset( pset_h from, pset_h *to, unsigned size )
{
   unsigned u ;
   char *func = "copy_pset" ;

   if ( *to == NULL )
   {
      *to = pset_create( pset_count( from ), 0 ) ;
      if ( *to == NULL )
      {
         out_of_memory( func ) ;
         return( FAILED ) ;
      }
   }

   for ( u = 0 ; u < pset_count( from ) ; u++ )
   {
      char *p = (char *) pset_pointer( from, u ) ;
      char *new ;
      
      if ( size == 0 )
         new = new_string( p ) ;
      else
         new = malloc( size ) ;

      if ( new == NULL )
      {
         out_of_memory( func ) ;
         return( FAILED ) ;
      }

      if ( size != 0 )
         (void) memcpy( new, p, (int) size ) ;

      if ( pset_add( *to, new ) == NULL )
      {
         free( new ) ;
         out_of_memory( func ) ;
         return( FAILED ) ;
      }
   }
   return( OK ) ;
}


/*
 * Disassociate from controlling terminal
 */
void no_control_tty()
{
#if !defined(HAVE_SETSID)
   int fd ;
   char *func = "no_control_tty" ;

   if ( ( fd = open( "/dev/tty", O_RDWR ) ) == -1 )
      msg( LOG_WARNING, func, "open of /dev/tty failed: %m" ) ;
   else
   {
      if ( ioctl( fd, TIOCNOTTY, (caddr_t)0 ) == -1 )
         msg( LOG_WARNING, func, "ioctl on /dev/tty failed: %m" ) ;
      (void) close( fd ) ;
   }
   (void) setpgrp( getpid(), 0 ) ;
#else
   (void) setsid() ;
#endif
}


/*
 * Write the whole buffer to the given file descriptor ignoring interrupts
 */
status_e write_buf( int fd, char *buf, int len )
{
   char *p ;
   int cc ;

   for ( p = buf ; len > 0 ; p += cc, len -= cc )
   {
      cc = write( fd, p, len ) ;
      if ( cc == -1 )
      {
         if ( errno != EINTR )
            return( FAILED ) ;
         cc = 0 ;
      }
   }
   return( OK ) ;
}


void tabprint( int fd, int tab_level, char *fmt, ...)
{
   va_list ap ;
   int i ;

   for ( i = 0 ; i < tab_level ; i++ )
      Sputchar( fd, '\t' ) ;

   va_start( ap, fmt ) ;
   Sprintv( fd, fmt, ap ) ;
   va_end( ap ) ;
}


/*
 * Receive a single IP packet worth of data.
 */
void drain( int sd )
{
   char buf[ 1 ] ;
   char cc ;

   cc = recv( sd, buf, sizeof( buf ), 0 ) ;
   if( debug.on )
      if ( cc == -1 )
         msg( LOG_WARNING, "drain", "recv: %m" ) ;
}

