
#include <errno.h>               /* for errno and ENOSYS */
#include <proc_secure.h>         /* for getsecsid() */

static inline int is_flask_enabled(void);

/* is_flask_enabled()
 *
 * This function is a predicate that returns 1 if the kernel has
 * the extra flask system calls, or 0 if it does not.
 */
static inline int is_flask_enabled( void ) {
  /* We'll call getsecsid() to see if the kernel has the extra flask *
   * system calls.  We aren't actually interested in the sid, we     *
   * just want to see if the system call is there.  We assume that   *
   * if getsecsid() is present, the other extra flask calls are too. */
  if( ( -1 == (int)getsecsid() ) && ( errno == ENOSYS ) ) {
    return( 0 );  /* kernel does not have extra flask system calls */
  } else {
    return( 1 );  /* kernel does have extra flask system calls */
  }
} /* is_flask_enabled() */
