#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/flask/flask.h>

/* System call used for all extended file calls. */
extern long flask_filecall(int call, unsigned long *args);

/* Individual extended file calls. */

extern long open_secure(const char *pathname, 
		       int flags, 
		       mode_t mode, 
		       security_id_t fd_sid, 
		       security_id_t f_sid);

extern long mkdir_secure(const char *pathname, 
			mode_t mode, 
			security_id_t sid);

extern long mknod_secure(const char *pathname, 
			 mode_t mode, 
			 dev_t dev, 
			 security_id_t sid);

extern long symlink_secure(const char *oldpath, 
			  const char *newpath, 
			  security_id_t sid);

extern long chsid(const char *pathname, 
		 security_id_t sid);

extern long lchsid(const char *pathname, 
		  security_id_t sid);

extern long fchsid(unsigned int fd, 
		  security_id_t sid);

extern long chsidfs(const char *pathname, 
		   security_id_t fs_sid, 
		   security_id_t f_sid);

extern long fchsidfs(unsigned int fd, 
		    security_id_t fs_sid, 
		    security_id_t f_sid);

extern long stat_secure(const char *pathname, 
		       struct stat *buf, 
		       security_id_t *out_sid);

extern long lstat_secure(const char *pathname, 
			struct stat *buf, 
			security_id_t *out_sid);

extern long fstat_secure(unsigned int fd, 
			struct stat *buf, 
			security_id_t *out_sid);

extern long statfs_secure(const char *pathname, 
			 struct statfs *buf, 
			 security_id_t *out_sid);

extern long fstatfs_secure(unsigned int fd, 
			  struct statfs *buf, 
			  security_id_t *out_sid);




