/* get_user_sid.h - contains header information and function prototypes
 *                  for functions to get a SID for a user
 */

#ifndef _GET_USER_SID_H_
#define _GET_USER_SID_H_

#include <config/flask.h>
#include <config/flask/mls.h>
#include <linux/flask/flask_types.h>
#include <linux/flask/security.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef CONFIG_FLASK_MLS
#define _SECCONTEXT_PATH "/etc/security/default_context.mls"
#else
#define _SECCONTEXT_PATH "/etc/security/default_context"
#endif
#define MAX_SECURITY_CONTEXT_TRIES  3


/*
 * get_default_user_sid - given username - the login id of the user, sets user_sid
 *                to the SID of the user
 *                Looks up the default security context.
 *                Returns 1 if a SID was found, 0 otherwise
 */
int get_default_user_sid (const char* username, const int len, 
			  security_context_t* user_context, security_id_t* user_sid);

/* get_user_sid - given username (the login id of the user), sets user_sid
   to the SID of the user and user_context to the security context upon which
   user_sid is based.  Returns 1 if a SID was found and 0 otherwise
 */
int get_user_sid (const char* username, const int len, 
                  security_context_t* user_context, security_id_t* user_sid);


/* The following functions are support functions for get_user_sid */
int find_sec_context (FILE* fseccon, const char* username, const int len,
                             security_context_t* def);
int obtain_user_sid (const char* username, 
                     const security_context_t defsec_context, 
                     security_context_t* user_context,
                     security_id_t* user_sid);
void query_user_sec_context (const char* username,
                             const security_context_t defsec_context,
                             security_context_t* trysec_context);
void get_field (const char* fieldstr, const char* deffield, 
                       char* newfield);
int security_context_to_parts (const security_context_t buf, char** user,
                               char** role, char** type, char** domain);
int parts_to_security_context (const char* user, const char* role, 
                               const char* type,
                               const char* domain, security_context_t* new);
#endif  /* ifndef _GET_USER_SID_H_ */
