#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <linux/flask/flask.h>

/* System call used for all extended socket calls. */
extern long socketcall(int call, unsigned long *args);

/* Individual extended socket calls. */

extern int 
socket_secure(int domain, int type, int protocol, security_id_t sid);

extern int 
accept_secure(int s, struct sockaddr *addr, int *addrlen, security_id_t *sid);

extern int 
connect_secure(int s, struct sockaddr *addr, int addrlen, security_id_t sid);

extern int 
getpeername_secure(int s, struct sockaddr *addr, int *addrlen, security_id_t *sid);

extern int 
listen_secure(int s, int backlog, security_id_t sid, int useclient);

extern int 
recvfrom_secure(int s, void *buf, int len, unsigned int flags, struct sockaddr *addr, int *addrlen, security_id_t *sso_sid, security_id_t *msg_sid);

extern int 
recvmsg_secure(int s, struct msghdr *msg, unsigned int flags, security_id_t *sso_sid, security_id_t *msg_sid);

extern int 
sendto_secure(int s, const void *buf, int len, unsigned int flags, struct sockaddr *addr, int addrlen, security_id_t dso_sid, security_id_t msg_sid);

extern int 
sendmsg_secure(int s, struct msghdr *msg, unsigned int flags, security_id_t dso_sid, security_id_t msg_sid);





