#include <unistd.h>
#include <linux/flask/security.h>

/* System call used for all security server and AVC calls. */
extern long flask_securitycall(int call, unsigned long *args);

/* Individual AVC calls. */

extern long avc_toggle(void);

/* Individual security server calls. */

extern long security_compute_av(struct security_query *query, 
				struct security_response *response);

extern long security_notify_perm(security_id_t ssid, 
				 security_id_t tsid, 
				 security_class_t tclass, 
				 access_vector_t requested);

extern long security_transition_sid(security_id_t ssid, 
				    security_id_t tsid, 
				    security_class_t tclass, 
				    security_id_t *out_sid);

extern long security_member_sid(security_id_t ssid, 
				security_id_t tsid, 
				security_class_t tclass, 
				security_id_t *out_sid);

extern long security_change_sid(security_id_t ssid, 
				security_id_t tsid, 
				security_class_t tclass, 
				security_id_t *out_sid);

extern long security_sid_to_context(security_id_t sid, 
				    security_context_t scontext, 
				    __u32 *scontext_len);

extern long security_context_to_sid(security_context_t scontext, 
				    __u32 scontext_len, 
				    security_id_t *out_sid);

extern long security_load_policy(char *path,
				 __u32 pathlen);

extern long security_get_sids(security_id_t *sids, 
			      __u32 *nel);

extern long security_get_user_sids(security_id_t fromsid,
				   char *username, 
				   __u32 namelen, 
				   security_id_t *sids, 
				   __u32 *nel);


/* Some helper functions for dealing with security classes
   and access vectors. */

extern security_class_t string_to_security_class(char *s);

extern void print_access_vector(security_class_t tclass, 
				access_vector_t av);
