#include <fs_secure.h>
#include "filecall.h"
#include <errno.h>

#include "kernel_stat.h"
#include "xstat_conv.h"

long fstat_secure(unsigned int fd,
		  struct stat *buf, 
		  security_id_t *out_sid)
{
	struct kernel_stat kbuf;
	unsigned long args[3];
	long err;
	
	args[0] = (unsigned long)fd;
	args[1] = (unsigned long)buf;
	args[2] = (unsigned long)out_sid;
	err = flask_filecall(FLASK_FILECALL_FSTAT_SECURE, args);
	if (err < 0) {
		if (errno == ENOSYS) {
			*out_sid = SECINITSID_UNLABELED;
			return fstat(fd, buf);
		}
		return err;
	}
	return xstat_conv(_STAT_VER_LINUX, &kbuf, buf);
}
