#include <unistd.h>
#include <ctype.h>
#include <linux/flask/flask.h>
#include <linux/flask/av_permissions.h>
#include <linux/flask/class_to_string.h>
#include <linux/flask/common_perm_to_string.h>
#include <linux/flask/av_inherit.h>
#include <linux/flask/av_perm_to_string.h>
#include <stdio.h>
#include <string.h>

#define NCLASSES ((sizeof class_to_string)/sizeof(char*))

security_class_t string_to_security_class(char *s)
{
	int val, len;

	len = strlen(s);
	if (len == 0) {
		fprintf(stderr, "\nThe null string is not a valid class.\n");
		return 0;
	}

	if (s[len-1] == '\n')
		len--;

	if (isdigit(s[0])) {
		val = atoi(s);
		if (val > 0 && val < NCLASSES)
			return val;
	} else { 
		for (val = 0; val < NCLASSES; val++) {
			if (strncmp(s, class_to_string[val], len) == 0)
				return val;
		}
	}
	
	fprintf(stderr, "\n%s is not a valid class value.\n", s);
	return 0;
}


void print_access_vector(
        security_class_t tclass,
        access_vector_t av)
{
        char          **common_pts = 0;
        access_vector_t common_base = 0;
        int             i, i2, perm;
 
 
        if (av == 0) {
                printf(" null");
                return;
        }

        for (i = 0; i < AV_INHERIT_SIZE; i++) {
                if (av_inherit[i].tclass == tclass) {
                        common_pts = av_inherit[i].common_pts;
                        common_base = av_inherit[i].common_base;
                        break;
                }
        }

        printf(" {");
        i = 0;  
        perm = 1;
        while (perm < common_base) {
                if (perm & av)
                        printf(" %s", common_pts[i]);
                i++;
                perm <<= 1;
        }

        while (i < sizeof(access_vector_t) * 8) {
                if (perm & av) {
                        for (i2 = 0; i2 < AV_PERM_TO_STRING_SIZE; i2++) {
                                if ((av_perm_to_string[i2].tclass == tclass) &&
                                    (av_perm_to_string[i2].value == perm))
                                        break;
                        }
                        if (i2 < AV_PERM_TO_STRING_SIZE)
                                printf(" %s", av_perm_to_string[i2].name);
                }
                i++;
                perm <<= 1;
        }
 
        printf(" }");
}
