/* msgget_secure.c
 * Author: Howard Holm, NSA <hdholm@epoch.ncsc.mil>
 *
 * This is the msgget_secure system call interface.  It is implemented
 * by calling the ipc system call with the parameters appropriately
 * shuffled.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/flask/flask.h>
#include <linux/msg.h>
#include <asm/ipc.h>

int
msgget_secure (key_t key, int msgflg, security_id_t sid)
{
  return ipc(MSGGETSEC, key, msgflg, NULL, &sid);
}
