/* msgsnd_secure.c
 * Author: Howard Holm, NSA <hdholm@epoch.ncsc.mil>
 *
 * This is the msgsnd_secure system call interface.  It is implemented
 * by calling the ipc system call with the parameters appropriately
 * shuffled.  Because the x86 implementation is limited in the number
 * of system call parameters, some of the paramters are bundled into
 * a structure.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/flask/flask.h>
#include <linux/msg.h>
#include <asm/ipc.h>

int
msgsnd_secure (int msqid, void *msgp, size_t msgsz, int msgflg,
	       security_id_t sid)
{
	struct ipc_kludge_secure tmp;

	tmp.msgp = msgp;
	tmp.flask.sid = sid;
	return ipc (MSGSNDSEC, msqid, msgsz, msgflg, &tmp);
}
