/* semget_secure.c
 * Author: Howard Holm, NSA <hdholm@epoch.ncsc.mil>
 *
 * This is the semget_secure system call interface.  It is implemented
 * by calling the ipc system call with the parameters appropriately
 * shuffled.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/flask/flask.h>
#include <linux/sem.h>
#include <asm/ipc.h>

int
semget_secure (key_t key, int nsems, int semflg, security_id_t sid)
{
	return ipc(SEMGETSEC, key, nsems, semflg, &sid);
}
