/* shmget_secure.c
 * Author: Howard Holm, NSA <hdholm@epoch.ncsc.mil>
 *
 * This is the shmget_secure system call interface.  It is implemented
 * by calling the ipc system call with the parameters appropriately
 * shuffled.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/flask/flask.h>
#include <linux/shm.h>
#include <asm/ipc.h>

int
shmget_secure (key_t key, int size, int shmflg, security_id_t sid)
{
	return ipc(SHMGETSEC, key, size, shmflg, &sid);
}
