/* shmsid.c
 * Author: Howard Holm, NSA <hdholm@epoch.ncsc.mil>
 *
 * This is the shmsid system call interface.  It is implemented
 * by calling the ipc system call with the parameters appropriately
 * shuffled.
 */

#include <linux/config.h>
#include <linux/types.h>
#include <linux/flask/flask.h>
#include <linux/shm.h>
#include <asm/ipc.h>

int
shmsid (int shmid, security_id_t *sid)
{
	return ipc(SHMSID, shmid, NULL, NULL, sid);
}
