/* call_security.c
 *
 * can be used to exercise various calls in the running security policy
 */

#include <ss.h>
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>

int sid_to_context(int sid)
{
  int ret_val, i;
  unsigned int default_size=255;
  char *scontext;
  unsigned int scontext_len;

  scontext=malloc(sizeof(char)*default_size);
  scontext_len = default_size;
  memset((void*)scontext, '\0', default_size);
  if (!scontext){
       ret_val=-ENOMEM;
       printf("\nget_sids: Not enough memory\n\n");
       exit (2);
  }

  ret_val=security_sid_to_context(sid,
				  scontext, &scontext_len);

  if (ret_val && (scontext_len>default_size)) {
           /* A larger context was needed */
           free(scontext);
           scontext=malloc(sizeof(char)*scontext_len);
           memset((void*)scontext, '\0', scontext_len);
           if (!scontext){
              ret_val=-ENOMEM;
              printf("\nget_sids: Not enough memory\n\n");
              return(2);
           }
           ret_val=security_sid_to_context(sid,
					   scontext, &scontext_len);
  }

  if (ret_val){
        perror("security_sid_to_context");
	free(scontext);
        return(2);
  }  

  printf("SID %d -> Scontext %s\n", sid, scontext);

  free(scontext);
  return (0);
}

int list_sids()
{
  int ret_val, i, nel;
  int default_size=255;
  security_id_t *sids;

  nel=default_size;
  sids=malloc(sizeof(security_id_t)*nel);
  if (!sids){
        ret_val=-ENOMEM;
        printf("\nget_sids: Not enough memory\n\n");
        exit (2);
  }

  ret_val=security_get_sids(sids, &nel);
  if (ret_val && (nel>default_size)){
        /* A larger sids array was needed */
        free(sids);
        sids=malloc(sizeof(security_id_t)*nel);
        if (!sids){
            ret_val=-ENOMEM;
            printf("\nget_sids: Not enough memory\n\n");
            exit (2);
        }
        ret_val=security_get_sids(sids, &nel);
  }

  if (ret_val){
        perror("security_get_sids");
        exit(2);
  }

  for (i=0; i<nel; i++) sid_to_context(sids[i]);

  printf("\n\n");
  free(sids);
  return (0);
}

int main(){
    char ans[80+1];
    char buf[225];
    char *path;
    int ret_val, len, trans, ssid, tsid, tclass, pathlen;
    struct security_query q;
    struct security_response r;
    security_id_t out_sid;
    security_context_t scontext;
    unsigned int scontext_len;

    trans=0;
menu:
    printf("\nSelect an option:\n");
    printf("0)  Call compute_access_vector\n");
    printf("1)  Call sid_to_context\n");
    printf("2)  Call context_to_sid\n");
    printf("3)  Call transition_sid\n");
    printf("4)  Call member_sid\n");
    printf("5)  Call list_sids\n");
    printf("6)  Call load_policy\n");
    printf("m)  Show menu again\n");
    printf("q)  Exit\n");
    while (1)
    {
        printf("\nChoose:  ");
        fgets(ans,sizeof(ans),stdin);
        switch (ans[0])
        {
          case '0':
            printf("source sid?  ");
            fgets(ans,sizeof(ans),stdin);
            q.ssid = atoi(ans);
 
            printf("target sid?  ");
            fgets(ans,sizeof(ans),stdin);
            q.tsid = atoi(ans);

            printf("target class?  ");
            fgets(ans,sizeof(ans),stdin);
	    q.tclass=string_to_security_class(ans);
	    if (!q.tclass) break;

 	    q.requested=0;
	
            ret_val=security_compute_av(&q, &r);

 	    if (ret_val) {
      		perror("security_compute_av");
  	    }

	    else {
                printf("\nAllowed: ");
                print_access_vector(q.tclass, r.allowed);
                printf("\n\n");
	    }   
	    break;

          case '1':
	    len=sizeof(buf);

            printf("sid?  ");
            fgets(ans,sizeof(ans),stdin);

  	    ret_val=security_sid_to_context(atoi(ans),
       		 buf, &len);

            if (ret_val) 
		perror("\nsecurity_sid_to_context");
            else
                printf("\nScontext: %s\n", buf);
            break;

          case '2':
            printf("scontext?  ");
            fgets(ans,sizeof(ans),stdin);
            len = strlen(ans);
            ans[len - 1] = 0;

	    ret_val=security_context_to_sid(ans,
 		len, &out_sid);

            if (ret_val) 
		perror("\nsecurity_context_to_sid");
            else
                printf("\nsid %ld\n", out_sid);
            break;

          case '3':
	    trans=1;

          case '4':
            printf("source sid?  ");
            fgets(ans,sizeof(ans),stdin);
            ssid = atoi(ans);
 
            printf("target sid?  ");
            fgets(ans,sizeof(ans),stdin);
            tsid = atoi(ans);
 
            printf("object class?  ");
            fgets(ans,sizeof(ans),stdin);
            tclass=string_to_security_class(ans);
            if (!tclass) break;

	    if (trans){ 
                ret_val=security_transition_sid(ssid, tsid, 
                        tclass, &out_sid);
            }
            else{
		ret_val=security_member_sid(ssid, tsid, 
			tclass, &out_sid);
            }
 
            if (ret_val) { 
               if (trans) perror("\nsecurity_transition_sid");
	       else perror ("\nsecurity_member_sid");
            } 
	    else
               printf("\nsid %ld\n", out_sid);
            trans=0;
            break;

          case '5':
            list_sids();
            break;

          case '6':
            printf("pathname?  ");
            fgets(ans,sizeof(ans),stdin);
	    pathlen = strlen(ans);
	    ans[pathlen-1]=0;
	    ret_val = security_load_policy(ans, pathlen);

            if (ret_val) 
		perror("\nsecurity_load_policy");
	    else
                printf("\nsuccess\n");
            break;
	  case 'm':
	    goto menu;
          case 'q':
            exit(0);
            break;
          default:
            printf("\nUnknown option %s.\n", ans);
        }
    }    
    return 0;
}
