/*
 * chcontext(): change security context of a pathname
 * 1/13/00
 */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <fs_secure.h>
#include <string.h>

static void usage ( );
static void pr_change ( );
int chcontext ( );

extern int errno;
int verbose = 0;


main ( int argc, char **argv )
{
  char *path, *scontext;

  if ( argc < 3 )
    usage(argv[0]);

  if ( argc == 4 ) {
    if ( strcasecmp(argv[1],"-v") )
      usage(argv[0]);
    else
      verbose++;

    path     = argv[2];
    scontext = argv[3];
  }
  else {
    path     = argv[1];
    scontext = argv[2];
  }

  exit( chcontext(path, scontext) );
}


int chcontext ( char *path, char *scontext )
{
  int rv;
  security_id_t new_sid, old_sid;
  struct stat st;


  rv = stat_secure(path, &st, &old_sid);

  if ( rv < 0 ) {
    (void) fprintf(stderr, "stat_secure(%s): %s\n", path, sys_errlist[errno]);
    return( 1 );
  }

  rv = security_context_to_sid(scontext, strlen(scontext)+1, &new_sid);
  if ( rv ){
    (void) fprintf(stderr, "security_context_to_sid(%s): %s\n", scontext, sys_errlist[errno]);
    return( 1 );
  }

  if ( old_sid != new_sid ) {
    rv = chsid(path, new_sid);
    if ( rv < 0 ) {
      (void) fprintf(stderr, "chsid(%s): %s\n", path, sys_errlist[errno]);
      return( 1 );
    }
  }

  if ( verbose )
    pr_change(path, old_sid, new_sid, scontext);

  return( 0 );
}


static void usage ( char *name )
{
  (void) fprintf(stderr, "Usage: %s [-v] pathname scontext\n", name);
  (void) fflush(stderr);

  exit( 1 );
}


static void pr_change ( char *path, security_id_t old, security_id_t new, char *ctx_new )
{
  char buf[256];
  unsigned int len = sizeof(buf);
  int rv;

  rv = security_sid_to_context(old, buf, &len);

  (void) printf("%s: [%d]'%s' --> [%d]'%s'\n", path, old, buf, new, ctx_new);
}

