#include <proc_secure.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  int ret_val=0;

  if (argc < 3) {
    printf("usage:  %s sid path arg ..\n", argv[0]);
    exit(1);
  }

/* this can obviously be broken with >7 parameters, but I 
   wasn't sure of a better way to do this short of generating
   the argv array, which execl_secure actually does. */

  switch (argc){
	case 3:
          ret_val = execl_secure(argv[2], atoi(argv[1]), argv[2], 0);
	case 4:
          ret_val = execl_secure(argv[2], atoi(argv[1]), argv[2], argv[3], 0);
	case 5: 
          ret_val = execl_secure(argv[2], atoi(argv[1]), argv[2], argv[3],
		argv[4], 0);
	case 6: 
          ret_val = execl_secure(argv[2], atoi(argv[1]), argv[2], argv[3],
		argv[4], argv[5], 0);
	case 7: 
          ret_val = execl_secure(argv[2], atoi(argv[1]), argv[2], argv[3],
		argv[4], argv[5], argv[6], 0);
	default:
	  printf("Too many arguments\n");
	  exit(1);
  } 

  if (ret_val<0){
	perror("execl_secure");
 	exit(2);
  }
  
  exit(0);
}
