#include <fs_secure.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  unsigned int fd;
  
  if (argc != 4) {
    printf("usage:  %s pathname fs_sid f_sid\n", argv[0]);
    exit(1);
  }

  fd = open(argv[1], O_RDONLY, 0);
  if (fd < 0) {
    perror(argv[1]);
    exit(2);
  }
  
  if (fchsidfs(fd, atoi(argv[2]), atoi(argv[3])) < 0) {
    perror("fchsidfs");
    exit(3);
  }
  
  exit(0);
}
