#include <fs_secure.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  unsigned int fd;
  struct statfs buf;
  security_id_t sid;
  
  if (argc != 2) {
    printf("usage:  %s pathname\n", argv[0]);
    exit(1);
  }

  fd = open(argv[1], O_RDONLY, 0);
  if (fd < 0) {
    perror(argv[1]);
    exit(2);
  }  
  
  if (fstatfs_secure(fd, &buf, &sid) < 0) {
    perror("fstatfs_secure");
    exit(3);
  }
  
  printf("blocks: %ld, available: %ld, sid *%d*\n",
	 buf.f_blocks, buf.f_bavail, sid);
  
  exit(0);
}
