/* 
 * get_user_sids.c
 *
 * Display the set of SIDs for legal security contexts 
 * for a given user that can be reached by a specified SID.
 */

#include <ss.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

static void nomem();

#define CONTEXT_LEN 255
#define SIDS_NEL 25

int main ( int argc, char **argv ) 
{
  int ret_val, i, nel;
  char *username;
  unsigned int namelen;
  security_id_t fromsid;
  security_id_t *sids;
  security_context_t context;
  unsigned int contextlen;

  if ( argc != 3 ) {
    fprintf(stderr, "usage:  %s fromsid user OR\n\t%s fromcontext user\n", argv[0], argv[0]);
    exit(1);
  }

  fromsid = atoi(argv[1]);
  if (fromsid == 0) {
    ret_val = security_context_to_sid(argv[1], strlen(argv[1])+1, &fromsid);
    if (ret_val) {
      fprintf(stderr, "%s:  invalid SID or context %s\n", argv[0], argv[1]);
      exit(1);      
    }
  }

  username = argv[2];
  namelen = strlen(argv[2])+1;

  nel = SIDS_NEL;
  sids = malloc(sizeof(security_id_t) * nel);
  if (!sids) {
    fprintf(stderr, "%s:  out of memory\n", argv[0]);
    exit(1);
  }

  ret_val = security_get_user_sids(fromsid, username, namelen, sids, &nel);
  if ( ret_val && (nel > SIDS_NEL) ) {
    free(sids);
    sids = malloc(sizeof(security_id_t) * nel);
    if (!sids) {
      fprintf(stderr, "%s:  out of memory\n", argv[0]);
      exit(1);
    }
    ret_val = security_get_user_sids(fromsid, username, namelen, sids, &nel);
  }

  if ( ret_val ) {
    perror("security_get_user_sids");
    exit(1);
  }

  for (i=0 ;i<nel ;i++ ) {
    contextlen = CONTEXT_LEN;
    context = malloc(CONTEXT_LEN);
    if (!context) {
      fprintf(stderr, "%s:  out of memory\n", argv[0]);
      exit(1);
    }
    memset(context, 0, contextlen);

    ret_val = security_sid_to_context(sids[i], context, &contextlen);
    if ( ret_val && (contextlen > CONTEXT_LEN) ) {
      free(context); 
      context = malloc(contextlen);
      if ( !context) {
	fprintf(stderr, "%s:  out of memory\n", argv[0]);
	exit(1);
      }

      ret_val = security_sid_to_context(sids[i], context, &contextlen);
    }

    if ( ! ret_val ) {
      (void) printf("\nSID %ld -> Scontext %s", sids[i], context);
      (void) fflush(stdout);
    }

    free(context);
  }

  (void) printf("\n\n");
  (void) fflush(stdout);

  free(sids);

  exit( 0 );
}


