/* getsecsid.c
 *
 * returns the SID and security context in which the user is 
 * currently running
 */

#include <stdlib.h>

int main(int argc, char **argv, char **envp) 
{
  int r;
  char scontext[256];
  int ctxtlen = 256;

  if (argc != 1) {
    printf("usage:  %s\n", argv[0]);
    exit(1);
  }
  
  if ((r=getsecsid()) < 0) {
    perror("getsecsid");
    exit(2);
  }
  printf("SID:  %d\n", r);

  if ( security_sid_to_context(r, scontext, &ctxtlen) ) {
    perror("getsecsid");
    exit(2);
  }
  
  printf ("Context:  %s\n", scontext);
  
  exit(0);
}
