/* load_policy.c
 *
 * used to load a new policy configuration froma  file containing
 * a binary representation of the configuration
 */

#include <ss.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv) 
{ 
  int ret_val, pathlen;
  char *path;

  if (argc != 2) {
    printf("usage:  %s path\n", argv[0]);
    exit(1);
  }

  path = strdup(argv[1]);
  pathlen=strlen(argv[1])+1;
  path[pathlen-1] = 0;
  ret_val = security_load_policy(path, pathlen);

  if (ret_val){
	perror("security_load_policy");
	exit(2);
  }

  printf("\nSuccess\n");
  exit(0);
}
