/* member_sid.c
 *
 * used to compute a SID to use when selecting a member of a polyinstantiated
 * object in a particular class based on a SID pair
 */

#include <ss.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  security_id_t out_sid;
  int tclass, ret_val;

  if (argc != 4) {
    printf("usage:  %s ssid tsid tclass\n\n", argv[0]);
    exit(1);
  }
 
  tclass = string_to_security_class(argv[3]);
  if (!tclass) exit (3);

  ret_val=security_member_sid(atol(argv[1]), atol(argv[2]),
                tclass, &out_sid);

  if (ret_val){
        perror("security_member_sid");
        exit(2);
  }

  printf("%lu\n",out_sid);
  exit(0);
}
