#include <fs_secure.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  unsigned long dev;
  security_id_t sid;

  if (argc != 4) {
    printf("usage:  %s pathname dev sid\n", argv[0]);
    exit(1);
  }

  dev = atoi(argv[2]);
  sid = atoi(argv[3]);

  if (mknod_secure(argv[1], S_IFCHR | 0644, dev, sid) < 0) {
    perror("mknod_secure");
    exit(2);
  }
  
  exit(0);
}
