/*
 * msgperm.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Read or set permissions on a message queue with the given id
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <sys/msg.h>

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage: %s id [perms]\n", progname);
  exit(1);
}

int main(int argc, char **argv)
{
  int id;
  struct msqid_ds *msg_arg;
  
  if (argc < 2) {
    fprintf (stderr, "Message queue ID is required.\n");
    usage(argv[0]);
  }
  if (argc > 3)
    usage(argv[0]);
  id = atoi(argv[1]);

  if ((msg_arg = (struct msqid_ds *)malloc (sizeof (struct msqid_ds))) == NULL) {
    perror("malloc failed");
    exit(1);
  }
  if (msgctl (id, IPC_STAT, msg_arg) < 0)
    perror ("msgctl(IPC_STAT) failed");
  else
    fprintf (stderr, "IPC_STAT permissions were: %#.3ho\n", msg_arg->msg_perm.mode);
  if (argc == 3) {
    msg_arg->msg_perm.mode = strtol(argv[2], (char *)0, 0);
    if (msgctl (id, IPC_SET, msg_arg) < 0)
      perror ("msgctl(IPC_SET) failed");
  }
  if (msgctl (id, IPC_STAT, msg_arg) < 0)
    perror ("msgctl(IPC_STAT) failed");
  else
    fprintf (stderr, "IPC_STAT permissions now: %#.3ho\n", msg_arg->msg_perm.mode);
  free (msg_arg);

}


