/*
 * msgread.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Read a message from the queue with the given id
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <linux/flask/flask.h>
#include <sys/msg.h>
#include <ipc_secure.h>

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage:  %s -i id [-c context | -s sid] [-t type]\n", progname);
  exit(1);
}

#define MAXMSGTESTED 4096

struct ipcmsgbuf {
  long mtype;     /* message type, must be > 0 */
  char mtext[MAXMSGTESTED];  /* message data */
};

int main(int argc, char **argv)
{
  int id, got_id = 0;
  struct ipcmsgbuf buf;
  char *message;
  int type = 1;
  security_id_t msg_sid = SECSID_NULL;
  int valid_msg_sid = 0;
  char context[255];
  int err, ret, c, contextlen, remove = 0;
  security_id_t sid = SECSID_NULL, tmpsid = SECSID_NULL;
  
  while ( (c = getopt(argc, argv, "c:i:s:t:")) != EOF) {
    switch (c) {
    case 's':
      if (valid_msg_sid) {
	fprintf (stderr, "Only a sid or a context may be given, not both\n");
	usage(argv[0]);
      } else {
	valid_msg_sid = 1;
	msg_sid = atoi(optarg);
      }
      break;
    case 'c':
      if (valid_msg_sid) {
	fprintf (stderr, "Only a sid or a context may be given, not both\n");
	usage(argv[0]);
      } else {
	valid_msg_sid =1;
	ret = security_context_to_sid(optarg,strlen(optarg)+1,&sid);
	if (ret) {
	  perror("Invalid context on command line");
	  exit(ret);
	}
      }
      break;
    case 'i':
      id = atoi(optarg);
      got_id = 1;
      break;
    case 't':
      type = atoi(optarg);
      break;
    default:
      usage(argv[0]);
    }
  }
  if (! got_id) {
    fprintf (stderr, "Message queue ID (-i) is required.\n");
    usage(argv[0]);
  }

  if (valid_msg_sid) {
    if (msgrcv_secure (id, &buf, MAXMSGTESTED, type, 0, &msg_sid) < 0)
      perror ("msgrcv failed");
    else
      fprintf (stderr, "Message QID: %d Type: %d RECEIVED:\n%s\n",
	       id, type, buf.mtext);
  } else {
    if (msgrcv (id, &buf, MAXMSGTESTED, type, 0) < 0)
      perror ("msgrcv failed");
    else
      fprintf (stderr, "Message QID: %d Type: %d RECEIVED:\n%s\n",
	       id, type, buf.mtext);
  }

}


