/* notify_perm.c
 *
 * used to notify the security server that an operation associated with a 
 * previously granted permission has successfully completed
 */

#include <ss.h>
#include <stdlib.h>

int main(int argc, char **argv) 
{
  int ret_val;

  if (argc != 5) {
    printf("usage:  %s ssid tsid tclass requested\n\n", argv[0]);
    exit(1);
  }
  
  ret_val=security_notify_perm(atol(argv[1]), atol(argv[2]), 
	atol(argv[3]), atol(argv[4]));

  if (ret_val){
      perror("security_notify_perm");
      exit(2);
    }

  printf("\nSuccess\n\n");
  exit(0);
}
