/*
 * get_scontext: return security context for a pathname, NULL on error
 * get_sid:      return SID for a pathname, -1 on error
 * 1/13/00 MITRE
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <fs_secure.h>

static void usage ( );

char *get_scontext ( );
security_id_t get_sid ( );

extern int errno;



int main ( int argc, char **argv )
{
  char *prog, *scontext, *path;
  security_id_t sid;

  if ( argc != 2 )
    usage(argv[0]);

  if ( strchr(argv[0],'/') != NULL ) {
    prog = strrchr(argv[0], '/')+1;
  }
  else
    prog = argv[0];

  path = argv[1];

  if ( strcmp(prog, "sid") == 0 ) {
    sid = get_sid(path);
    if ( (int) sid >= 0 ) {
      (void) printf("%d\n", (int) sid);
      (void) fflush(stdout);
      exit( 0 );
    }
  }
  else {
    scontext = get_scontext(path);
    if ( scontext != NULL ) {
      (void) printf("%s\n", scontext);
      (void) fflush(stdout);
      exit( 0 );
    }
  }

    exit( 1 );
}


/*
 * get_scontext(pathname): return security context for pathname, NULL on error 
 */


char *get_scontext ( char *path )
{
  int rv;
  security_id_t sid;
  struct stat st;
  static char buf[256];
  unsigned int len = sizeof(buf);


  rv = stat_secure(path, &st, &sid);
  if ( rv < 0 ) {
    (void) fprintf(stderr, "stat_secure(%s): %s\n", path, sys_errlist[errno]);
    (void) fflush(stderr);
    return( (char *) NULL );
  }

  bzero(buf, 256);

  rv = security_sid_to_context(sid, buf, &len);
  if ( rv ) {
    (void) fprintf(stderr, "security_sid_to_context(%d, %s): %s\n", (int)sid, path, sys_errlist[errno]);
    (void) fflush(stderr);
    return( (char *) NULL );
  }

  return( buf );
}


/*
 * get_sid(pathname): return SID for pathname, -1 on error
 */


security_id_t get_sid ( char *path )
{
  int rv;
  security_id_t sid;
  struct stat st;


  rv = stat_secure(path, &st, &sid);
  if ( rv < 0 ) {
    (void) fprintf(stderr, "stat_secure(%s): %s\n", path, sys_errlist[errno]);
    (void) fflush(stderr);
    return( (security_id_t) -1 );
  }

  return( sid );
}


static void usage ( char *name )
{
  (void) fprintf(stderr, "Usage: %s pathname\n", name);
  (void) fflush(stderr);

  exit( 1 );
}

