/*
 * semperm.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Read or set permissions on a semaphore set with the given id
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <sys/sem.h>

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
  /* union semun is defined by including <sys/sem.h> */
#else
  /* according to X/OPEN we have to define it ourselves */
  union semun {
    int val;                    /* value for SETVAL */
    struct semid_ds *buf;       /* buffer for IPC_STAT, IPC_SET */
    unsigned short int *array;  /* array for GETALL, SETALL */
    struct seminfo *__buf;      /* buffer for IPC_INFO */
  };
#endif

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage: %s id [perms]\n", progname);
  exit(1);
}

int main(int argc, char **argv)
{
  int id;
  union semun sem_arg;
  
  if (argc > 3)
    usage (argv[0]);
  if (argc < 2) {
    fprintf (stderr, "Semaphore ID is required.\n");
    usage(argv[0]);
  }
  id = atoi(argv[1]);
  
  if ((sem_arg.buf = (struct semid_ds *)malloc (sizeof (struct semid_ds))) == NULL) {
    perror("malloc failed");
    exit(1);
  }
  if (semctl (id, 0, IPC_STAT, sem_arg) < 0)
    perror ("semctl(IPC_STAT) failed");
  else
    fprintf (stderr, "IPC_STAT permissions were: %#.3ho\n", sem_arg.buf->sem_perm.mode);
  if (argc == 3) {
    sem_arg.buf->sem_perm.mode = strtol(argv[2], (char *)0, 0);
    if (semctl (id, 0, IPC_SET, sem_arg) < 0)
      perror ("semctl(IPC_SET failed");
  }
  if (semctl (id, 0, IPC_STAT, sem_arg) < 0)
    perror ("semctl(IPC_STAT) failed");
  else
    fprintf (stderr, "IPC_STAT permissions now: %#.3ho\n", sem_arg.buf->sem_perm.mode);
  free (sem_arg.buf);

}


