/*
 * semwrite.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Write a semaphore set with the given id
 *
 */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/sem.h>
#include <ipc_secure.h>

#define MAXSEMSTESTED 20

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage:  %s id {semaphore-number semaphore-operation}\n", progname);
  fprintf(stderr, "        see semop(2) for meaning of operation numbers\n");
  exit(1);
}

int main(int argc, char **argv)
{
  int id;
  struct sembuf semops[MAXSEMSTESTED];
  int nsems = 0;

  if ((argc < 4) || ((argc / 2) * 2  != argc)) {
    fprintf (stderr, "Semaphore set id, and at least one semaphore number and operation pair are requried.\n");
    usage(argv[0]);
  }
  if (argc > (MAXSEMSTESTED * 2) + 2) {
    fprintf (stderr, "Only %d semaphores may be used.\n", MAXSEMSTESTED);
    usage(argv[0]);
  }
  id = atoi (argv[1]);

  for (nsems = 0; nsems < argc/2 - 1; nsems++) {
    semops[nsems].sem_num = atoi(argv[2 + nsems]);
    semops[nsems].sem_op = atoi(argv[3 + nsems]);
    /* note that this program does not test NOWAIT and UNDO flag operations */
    /* add to command line and use the new input in sem_flg to fix */
    semops[nsems].sem_flg = 0;
  }

  if (semop (id, semops, nsems) < 0)
    perror ("semop failed");
  else
    fprintf (stderr, "%s: semop reports success\n", argv[0]);

}


