/*
 * shmperm.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * Read or set permissions on a memory segment with the given id
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <sys/shm.h>

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage: %s id [perms]\n", progname);
  exit(1);
}

int main(int argc, char **argv)
{
  int id;
  struct shmid_ds *shm_arg;
  
  if (argc < 2) {
    fprintf (stderr, "Shared memory segment ID is required.\n");
    usage(argv[0]);
  }
  if (argc > 3)
    usage(argv[0]);
  id = atoi(argv[1]);

  if ((shm_arg = (struct shmid_ds *)malloc (sizeof (struct shmid_ds))) == NULL) {
    perror("malloc failed");
    exit(1);
  }
  if (shmctl (id, IPC_STAT, shm_arg) < 0)
    perror ("shmctl(IPC_STAT) failed");
  else
    fprintf (stderr, "IPC_STAT permissions were: %#.3ho\n", shm_arg->shm_perm.mode);
  if (argc == 3) {
    shm_arg->shm_perm.mode  = strtol(argv[2], (char *)0, 0);
    if (shmctl (id, IPC_SET, shm_arg) < 0)
      perror ("shmctl(IPC_SET) failed");
  }
  if (shmctl (id, IPC_STAT, shm_arg) < 0)
    perror ("shmctl(IPC_STAT) failed");
  else
    fprintf (stderr, "IPC_STAT permissions now: %#.3ho\n", shm_arg->shm_perm.mode);
  free (shm_arg);

}


